// EnderToolUseEvent.java
package com.stools.event;

import com.stools.config.ModConfigManager;
import com.stools.entity.EnderPhantomEntity;
import com.stools.item.materials.ModToolMaterials;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class EnderAlloyToolUseEvent {

    // 用于跟踪残影实体和它们的消失时间
    private static final Map<UUID, Long> ghostEntities = new HashMap<>();
    private static final int DURABILITY_COST = 80;
    private static final int GHOST_DURATION = 3 * 20; // 3秒，以tick为单位

    public static void register() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills) {
                return class_1271.method_22430(stack);
            }
            if (player.method_5715() && stack.method_7909() instanceof class_1831 toolItem) {
                if (toolItem.method_8022() == ModToolMaterials.ENDER_ALLOY) {
                    if (stack.method_7919() + DURABILITY_COST >= stack.method_7936()) {
                        return class_1271.method_22431(stack);
                    }

                    if (!world.method_8608()) {
                        stack.method_7956(DURABILITY_COST, player, e -> e.method_20236(hand));
                        teleportPlayer(player, (class_3218) world);
                    }

                    return class_1271.method_22427(stack);
                }
            }
            return class_1271.method_22430(stack);
        });
    }

    private static void teleportPlayer(class_1657 player, class_3218 world) {
        // 只考虑水平方向（忽略垂直视角）
        class_243 horizontalLookVec = class_243.method_1030(0, player.method_36454());

        double maxDistance = 8.0;
        class_243 startPos = player.method_19538().method_1031(0, player.method_5751(), 0);
        class_243 endPos = startPos.method_1019(horizontalLookVec.method_1021(maxDistance));

        // 进行方块视线检测（仅水平）
        class_3959 context = new class_3959(
                startPos,
                endPos,
                class_3959.class_3960.field_17558,
                class_3959.class_242.field_1348,
                player
        );

        net.minecraft.class_3965 blockHit = world.method_17742(context);

        // 目标位置为视线交点或最大距离
        class_243 targetPos = blockHit.method_17783() == net.minecraft.class_3965.Type.field_1333 ?
                endPos : blockHit.method_17784();

        // 创建残影
        createGhostEntity(world, player.method_19538(), player);

        // 调整目标位置确保玩家站在地面上
        class_2338 targetBlockPos = class_2338.method_49638(targetPos);
        for (int i = 0; i < 5; i++) {
            class_2338 downPos = targetBlockPos.method_10074();
            if (world.method_8320(downPos).method_26212(world, downPos)) {
                targetPos = new class_243(targetPos.field_1352, targetBlockPos.method_10264(), targetPos.field_1350);
                break;
            }
            targetBlockPos = downPos;
        }

        // 传送玩家（保持当前高度或调整到地面）
        player.method_20620(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350);

        // 播放传送效果
        world.method_8396(null, player.method_24515(), class_3417.field_14879,
                class_3419.field_15248, 1.0f, 1.0f);
        world.method_14199(class_2398.field_11214,
                player.method_23317(), player.method_23318() + 1, player.method_23321(),
                50, 0.5, 0.5, 0.5, 0.1);

        // 给玩家短暂的速度提升效
        player.method_6092(new class_1293(class_1294.field_5904, 60, 1, false, true));
    }

    private static void createGhostEntity(class_3218 world, class_243 pos, class_1657 player) {
        EnderPhantomEntity ghost = new EnderPhantomEntity(world, player);
        world.method_8649(ghost);

        // 添加粒子效果
        world.method_14199(class_2398.field_23190,
                pos.field_1352, pos.field_1351 + 1, pos.field_1350,
                20, 0.5, 0.5, 0.5, 0.05);

        ghostEntities.put(ghost.method_5667(), world.method_8510() + GHOST_DURATION);
    }

    public static void tick(class_3218 world) {
        long currentTime = world.method_8510();

        // 处理残影消失
        ghostEntities.entrySet().removeIf(entry -> {
            UUID ghostId = entry.getKey();
            long removeTime = entry.getValue();
            class_1297 entity = world.method_14190(ghostId);

            if (entity == null || currentTime >= removeTime) {
                if (entity != null) {
                    // 消失前播放效果
                    world.method_14199(class_2398.field_11251,
                            entity.method_23317(), entity.method_23318() + 1, entity.method_23321(),
                            20, 0.3, 0.3, 0.3, 0.05);
                    entity.method_31472();
                }
                return true;
            }
            return false;
        });
    }
}