package com.stools.event;

import com.stools.config.ModConfigManager;
import com.stools.item.materials.ModToolMaterials;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class NetherStarToolUseEvent {

    private static final int DURABILITY_COST = 220;
    private static final int RIFT_DURATION = 100; // 5秒(20tick/s)
    private static final Map<UUID, RiftData> activeRifts = new HashMap<>();

    public static class RiftData {
        public class_2338 position;
        public int remainingTicks;
        public class_1657 creator;

        public RiftData(class_2338 pos, int duration, class_1657 player) {
            this.position = pos;
            this.remainingTicks = duration;
            this.creator = player;
        }
    }

    public static void register() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills) {
                return class_1271.method_22430(stack);
            }
            if (player.method_5715() && stack.method_7909() instanceof class_1831 toolItem) {
                if (toolItem.method_8022() == ModToolMaterials.NETHER_STAR) {
                    if (stack.method_7919() + DURABILITY_COST >= stack.method_7936()) {
                        return class_1271.method_22431(stack);
                    }

                    if (!world.method_8608()) {
                        stack.method_7956(DURABILITY_COST, player, e -> e.method_20236(hand));
                        createWitherNova(player, (class_3218) world);
                    }

                    return class_1271.method_22427(stack);
                }
            }
            return class_1271.method_22430(stack);
        });
    }

    private static void createWitherNova(class_1657 player, class_3218 world) {
        // 获取目标位置
        class_243 lookVec = player.method_5828(1.0F);
        class_243 targetPos = player.method_19538().method_1019(lookVec.method_1021(12));

        class_2338 novaPos = world.method_17742(new class_3959(
                player.method_5836(1.0F),
                targetPos,
                class_3959.class_3960.field_17558,
                class_3959.class_242.field_1348,
                player
        )).method_17777().method_10084();

        // 创建新星数据
        activeRifts.put(UUID.randomUUID(), new RiftData(novaPos, RIFT_DURATION, player));

        // 初始效果
        world.method_8396(null, novaPos,
                class_3417.field_14588,
                class_3419.field_15248, 1.5f, 0.8f);

        // 生成初始粒子
        for (int i = 0; i < 50; i++) {
            double offsetX = (world.field_9229.method_43058() - 0.5) * 3;
            double offsetY = world.field_9229.method_43058() * 2;
            double offsetZ = (world.field_9229.method_43058() - 0.5) * 3;
            world.method_14199(class_2398.field_22246,
                    novaPos.method_10263() + 0.5 + offsetX,
                    novaPos.method_10264() + 0.5 + offsetY,
                    novaPos.method_10260() + 0.5 + offsetZ,
                    5, 0, 0, 0, 0.1);
        }
    }

    // 在ServerTick中调用
    public static void updateRifts(class_3218 world) {
        activeRifts.entrySet().removeIf(entry -> {
            RiftData rift = entry.getValue();
            rift.remainingTicks--;

            // 引力效果
            applyGravityEffect(world, rift);

            // 粒子效果
            spawnRiftParticles(world, rift);

            // 终结爆炸
            if (rift.remainingTicks <= 0) {
                createFinalExplosion(world, rift);
                return true; // 移除裂隙
            }
            return false;
        });
    }

    private static void applyGravityEffect(class_3218 world, RiftData rift) {
        double radius = 8.0;
        class_238 area = new class_238(
                rift.position.method_10263() - radius,
                rift.position.method_10264() - 2,
                rift.position.method_10260() - radius,
                rift.position.method_10263() + radius,
                rift.position.method_10264() + 4,
                rift.position.method_10260() + radius
        );

        class_243 center = new class_243(
                rift.position.method_10263() + 0.5,
                rift.position.method_10264() + 0.5,
                rift.position.method_10260() + 0.5
        );

        for (class_1297 entity : world.method_8335(null, area)) {
            if (entity instanceof class_1309 || entity instanceof class_1541) {
                class_243 toCenter = center.method_1020(entity.method_19538()).method_1029();
                double distance = center.method_1022(entity.method_19538());
                double strength = 0.3 * (1 - (distance / radius));

                // 拉向中心
                entity.method_5762(toCenter.field_1352 * strength, toCenter.field_1351 * strength * 0.7, toCenter.field_1350 * strength);

                // 每秒伤害并附加凋灵效果
                if (rift.remainingTicks % 20 == 0 && entity instanceof class_1309 livingEntity) {
                    float damage = 3.0f + (rift.creator.method_7261(0) * 4);
                    livingEntity.method_5643(world.method_48963().method_48832(), damage);

                    //凋灵效果
                    livingEntity.method_6092(new class_1293(
                            class_1294.field_5920,
                            100, // 5秒
                            1,   // 等级2
                            false,
                            true
                    ));
                }
            }
        }
    }

    private static void spawnRiftParticles(class_3218 world, RiftData rift) {
        // 核心粒子
        world.method_14199(class_2398.field_23114,
                rift.position.method_10263() + 0.5,
                rift.position.method_10264() + 0.5,
                rift.position.method_10260() + 0.5,
                10, 0.2, 0.2, 0.2, 0.05);

        // 边缘粒子
        if (world.field_9229.method_43057() < 0.3f) {
            double angle = world.field_9229.method_43058() * Math.PI * 2;
            double distance = 1.5 + world.field_9229.method_43058() * 1.5;
            double x = rift.position.method_10263() + 0.5 + Math.cos(angle) * distance;
            double z = rift.position.method_10260() + 0.5 + Math.sin(angle) * distance;

            world.method_14199(class_2398.field_11251,
                    x, rift.position.method_10264() + 0.8, z,
                    3, 0, 0.1, 0, 0.05);
        }
    }

    private static void createFinalExplosion(class_3218 world, RiftData rift) {
        // 爆炸效果
        world.method_8437(null,
                rift.position.method_10263() + 0.5,
                rift.position.method_10264() + 0.5,
                rift.position.method_10260() + 0.5,
                5.0f, class_1937.class_7867.field_40890);

        // 爆炸
        world.method_8396(null, rift.position,
                class_3417.field_15236,
                class_3419.field_15248, 2.0f, 0.7f);

        // 爆炸粒子
        for (int i = 0; i < 30; i++) {
            double angle = world.field_9229.method_43058() * Math.PI * 2;
            double distance = world.field_9229.method_43058() * 3;
            double x = Math.cos(angle) * distance;
            double z = Math.sin(angle) * distance;

            world.method_14199(class_2398.field_22246,
                    rift.position.method_10263() + 0.5 + x,
                    rift.position.method_10264() + 0.5,
                    rift.position.method_10260() + 0.5 + z,
                    5, 0, 0.2, 0, 0.1);
        }
    }
}