package com.stools.event;

import com.stools.config.ModConfigManager;
import com.stools.item.materials.ModToolMaterials;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import java.util.Random;

public class PoPotatoToolUseEvent {
    private static final Random random = new Random();
    private static final int POISON_DURATION = 80; // 4秒 (20 ticks/秒 * 4)

    public static void register() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);

            // 检查总开关是否开启
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills) {
                return class_1271.method_22430(stack);
            }

            // 检查是否为潜行状态和毒土豆工具
            if (player.method_5715() && stack.method_7909() instanceof class_1831 toolItem) {
                if (toolItem.method_8022() == ModToolMaterials.POISONOUS_POTATO) {
                    int currentDamage = stack.method_7919();
                    int maxDamage = stack.method_7936();
                    int remainingDurability = maxDamage - currentDamage;
                    int consumeAmount = Math.min(remainingDurability, 50);

                    if (!world.method_8608()) {
                        // 消耗耐久度
                        stack.method_7956(consumeAmount, player, e -> e.method_20236(hand));

                        // 恢复饥饿度
                        class_1702 hungerManager = player.method_7344();
                        hungerManager.method_7585(2, 1.2f);

                        // 播放音效
                        world.method_8396(null, player.method_24515(),
                                class_3417.field_20614,
                                class_3419.field_15248, 1.0F, 1.0F);

                        // 应用中毒效果
                        applyPoisonEffect(player, world);

                        // 耐久耗尽时掉落木棍
                        if (stack.method_7919() >= stack.method_7936()) {
                            class_1799 stickStack = new class_1799(class_1802.field_8600);
                            if (!player.method_31548().method_7394(stickStack)) {
                                player.method_7328(stickStack, false);
                            }
                        }
                    }

                    return class_1271.method_22427(stack);
                }
            }
            return class_1271.method_22430(stack);
        });
    }

    private static void applyPoisonEffect(class_1657 player, class_1937 world) {
        // 获取配置中的中毒概率
        float poisonChance = ModConfigManager.CONFIG.toolEffects.poisonousPotatoEatPoisonChance / 100f;

        // 根据概率决定是否中毒
        if (random.nextFloat() < poisonChance) {
            player.method_6092(new class_1293(
                    class_1294.field_5899,
                    POISON_DURATION, // 4秒
                    0,              // 等级I
                    false,
                    true
            ));
        }
    }
}