package com.stools.item;

import com.stools.Strangetools;
import com.stools.item.custom.VoidPearlItem;
import com.stools.item.materials.ModArmorMaterials;
import com.stools.item.materials.ModMaceMaterials;
import com.stools.item.materials.ModToolMaterials;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1829;
import net.minecraft.class_1834;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_8052;
import net.minecraft.item.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModItems {
    public static final class_1792 BK_TEST_ITEM = registerItem("bk_test_item",new class_1792(new class_1792.class_1793()));
    public static final class_1792 TEST_ITEM = registerItem("test_item", new class_1829(class_1834.field_8922, 6, 1, new class_1792.class_1793().method_7895(1)));
    public static final class_1792 ENDER_ALLOY_INGOT = registerItem("ender_alloy_ingot", new class_1792(new class_1792.class_1793()));
    public static final class_1792 ENDER_ALLOY_SCRAP = registerItem("ender_alloy_scrap", new class_1792(new class_1792.class_1793()));
    public static final class_1792 ENDER_ALLOY_UPGRADE_SMITHING_TEMPLATE = registerItem(
            "ender_alloy_upgrade_smithing_template",
            createEnderAlloyUpgradeTemplate()
    );
    public static final class_1792 APPLE_UPGRADE_SMITHING_TEMPLATE = registerItem("apple_upgrade_smithing_template",
            createAppleUpgradeTemplate()
    );
    public static final class_1792 VOID_INGOT = registerItem("void_ingot", new class_1792(new class_1792.class_1793()));
    public static final class_1792 VOID_PEARL = registerItem("void_pearl",
            new VoidPearlItem(new class_1792.class_1793())
    );
    public static final class_1792 RAW_VOID = registerItem("raw_void", new class_1792(new class_1792.class_1793()));

    public static final class_1792 SLICE_OF_CAKE = registerItem("slice_of_cake",new class_1792(new class_1792.class_1793().method_19265(ModFoodComponents.S_CAKE)));
    public static final class_1792 AMETHYST_INGOT = registerItem("amethyst_ingot",new class_1792(new class_1792.class_1793()));
    public static final class_1792 LAVA_INGOT = registerItem("lava_ingot", new class_1792(new class_1792.class_1793()));
    public static final class_1792 WATER_INGOT = registerItem("water_ingot", new class_1792(new class_1792.class_1793()));
    public static final Map<String, class_1792> TOOLS = new HashMap<>();
    public static final List<String> TOOL_IDS = new ArrayList<>();
    public static final Map<String, class_1792> ARMORS = new HashMap<>();
    public static final List<String> ARMOR_IDS = new ArrayList<>();

    public static void registerToolSet(ModToolMaterials material, String materialName) {
        String prefix = materialName + "_";

        registerTool(prefix + "sword", ToolFactory.createSword(material, prefix + "sword"));
        registerTool(prefix + "pickaxe", ToolFactory.createPickaxe(material, prefix + "pickaxe"));
        registerTool(prefix + "axe", ToolFactory.createAxe(material, prefix + "axe"));
        registerTool(prefix + "shovel", ToolFactory.createShovel(material, prefix + "shovel"));
        registerTool(prefix + "hoe", ToolFactory.createHoe(material, prefix + "hoe"));
    }

    private static void registerArmorSet(ModArmorMaterials material, String materialName) {
        String prefix = materialName + "_";

        registerArmor(prefix + "helmet", ArmorFactory.createHelmet(material, prefix + "helmet"));
        registerArmor(prefix + "chestplate", ArmorFactory.createChestplate(material, prefix + "chestplate"));
        registerArmor(prefix + "leggings", ArmorFactory.createLeggings(material, prefix + "leggings"));
        registerArmor(prefix + "boots", ArmorFactory.createBoots(material, prefix + "boots"));
    }

    public static void registerTool(String id, class_1792 item) {
        class_1792 registeredItem = registerItem(id, item);
        TOOLS.put(id, registeredItem);
        TOOL_IDS.add(id);
    }

    private static void registerArmor(String id, class_1792 item) {
        class_1792 registeredItem = registerItem(id, item);
        ARMORS.put(id, registeredItem);
        ARMOR_IDS.add(id);
    }

    private static void registerMaceSet(ModMaceMaterials material, String materialName) {
        String id = materialName + "_mace";
        registerTool(id, MaceFactory.createMace(material, id));
    }

    public static void registerToolItems() {
        registerToolSet(ModToolMaterials.DIRT, "dirt");
        registerToolSet(ModToolMaterials.COPPER, "copper");
        registerToolSet(ModToolMaterials.EMERALD, "emerald");
        registerToolSet(ModToolMaterials.LAPIS, "lapis");
        registerToolSet(ModToolMaterials.REDSTONE, "redstone");
        registerToolSet(ModToolMaterials.QUARTZ, "quartz");
        registerToolSet(ModToolMaterials.COAL, "coal");
        registerToolSet(ModToolMaterials.CAKE, "cake");
        registerToolSet(ModToolMaterials.OBSIDIAN, "obsidian");
        registerToolSet(ModToolMaterials.PRISMARINE, "prismarine");
        registerToolSet(ModToolMaterials.ROTTEN_FLESH, "rotten_flesh");
        registerToolSet(ModToolMaterials.GLOWSTONE, "glowstone");
        registerToolSet(ModToolMaterials.BLAZE_POWDER, "blaze_powder");
        registerToolSet(ModToolMaterials.APPLE, "apple");
        registerToolSet(ModToolMaterials.GOLDEN_APPLE, "golden_apple");
        registerToolSet(ModToolMaterials.ENCHANTED_GOLDEN_APPLE, "enchanted_golden_apple");
        registerToolSet(ModToolMaterials.BEDROCK, "bedrock");
        registerToolSet(ModToolMaterials.BONE, "bone");
        registerToolSet(ModToolMaterials.NETHERRACK, "netherrack");
        registerToolSet(ModToolMaterials.NETHER_STAR, "nether_star");
        registerToolSet(ModToolMaterials.GLASS, "glass");
        registerToolSet(ModToolMaterials.SLIME, "slime");
        registerToolSet(ModToolMaterials.POTION, "potion");
        registerToolSet(ModToolMaterials.STRING, "string");
        registerToolSet(ModToolMaterials.ENDER_ALLOY, "ender_alloy");
        registerToolSet(ModToolMaterials.END_STONE, "end_stone");
        registerToolSet(ModToolMaterials.CHORUS_FRUIT, "chorus_fruit");
        registerToolSet(ModToolMaterials.VOID, "void");
        registerToolSet(ModToolMaterials.WATERMELON,"melon");
        registerToolSet(ModToolMaterials.SWEET_BERRIES,"sweet_berries");
        registerToolSet(ModToolMaterials.GLOW_BERRIES,"glow_berries");
        registerToolSet(ModToolMaterials.CARROT,"carrot");
        registerToolSet(ModToolMaterials.GOLDEN_CARROT,"golden_carrot");
        registerToolSet(ModToolMaterials.POTATO,"potato");
        registerToolSet(ModToolMaterials.POISONOUS_POTATO,"poisonous_potato");
        registerToolSet(ModToolMaterials.AMETHYST,"amethyst");
        registerToolSet(ModToolMaterials.FLINT,"flint");
        registerToolSet(ModToolMaterials.WHEAT,"wheat");
        registerToolSet(ModToolMaterials.BEETROOT,"beetroot");
        registerToolSet(ModToolMaterials.DRIED_KELP,"dried_kelp");
        registerToolSet(ModToolMaterials.BLUE_ICE,"blue_ice");
        registerToolSet(ModToolMaterials.RAW_BEEF,"raw_beef");
        registerToolSet(ModToolMaterials.STEAK, "steak");
        registerToolSet(ModToolMaterials.LEATHER,"leather");
        registerToolSet(ModToolMaterials.LAVA,"lava");
        registerToolSet(ModToolMaterials.WATER,"water");

        //盔甲
        registerArmorSet(ModArmorMaterials.COPPER, "copper");
        registerArmorSet(ModArmorMaterials.EMERALD, "emerald");
        registerArmorSet(ModArmorMaterials.LAPIS, "lapis");
        registerArmorSet(ModArmorMaterials.REDSTONE, "redstone");
        registerArmorSet(ModArmorMaterials.COAL, "coal");
        registerArmorSet(ModArmorMaterials.OBSIDIAN, "obsidian");

        //重锤
    }

    public static class_1792 registerItem(String id, class_1792 item) {
        return class_2378.method_10230(class_7923.field_41178, new class_2960(Strangetools.MOD_ID, id), item);
    }

    public static class_1792 register(String id, class_1792 item) {
        return register(new class_2960(Strangetools.MOD_ID, id), item);
    }

    public static class_1792 register(class_2960 id, class_1792 item) {
        return register(class_5321.method_29179(class_7923.field_41178.method_30517(), id), item);
    }

    public static class_1792 register(class_5321<class_1792> key, class_1792 item) {
        if (item instanceof class_1747) {
            ((class_1747) item).method_7713(class_1792.field_8003, item);
        }

        return class_2378.method_39197(class_7923.field_41178, key, item);
    }

    public static void registerItems() {
        registerToolItems();
    }

    private static class_8052 createEnderAlloyUpgradeTemplate() {
        // 自定义文本（这些需要添加到语言文件中）
        class_2561 appliesTo = class_2561.method_43471("item.strangetools.smithing_template.ender_alloy_upgrade.applies_to")
                .method_27692(class_124.field_1078);
        class_2561 ingredients = class_2561.method_43471("item.strangetools.smithing_template.ender_alloy_upgrade.ingredients")
                .method_27692(class_124.field_1078);
        class_2561 title = class_2561.method_43471("upgrade.strangetools.ender_alloy_upgrade")
                .method_27692(class_124.field_1080);
        class_2561 baseSlotDesc = class_2561.method_43471("item.strangetools.smithing_template.ender_alloy_upgrade.base_slot_description");
        class_2561 additionsSlotDesc = class_2561.method_43471("item.strangetools.smithing_template.ender_alloy_upgrade.additions_slot_description");

        // 基础槽位的空图标（显示在锻造界面）
        List<class_2960> emptyBaseSlots = List.of(
                new class_2960("item/empty_armor_slot_helmet"),
                new class_2960("item/empty_slot_sword"),
                new class_2960("item/empty_armor_slot_chestplate"),
                new class_2960("item/empty_slot_pickaxe"),
                new class_2960("item/empty_armor_slot_leggings"),
                new class_2960("item/empty_slot_axe"),
                new class_2960("item/empty_armor_slot_boots"),
                new class_2960("item/empty_slot_hoe"),
                new class_2960("item/empty_slot_shovel")
        );

        // 附加槽位的空图标
        List<class_2960> emptyAdditionsSlots = List.of(
                new class_2960("item/empty_slot_ingot")
        );

        return new class_8052(
                appliesTo,
                ingredients,
                title,
                baseSlotDesc,
                additionsSlotDesc,
                emptyBaseSlots,
                emptyAdditionsSlots
        ) {
            @Override
            public String method_7876() {
                return "item.strangetools.ender_alloy_upgrade_smithing_template";
            }
        };
    }

    private static class_8052 createAppleUpgradeTemplate() {
        // 自定义文本
        class_2561 appliesTo = class_2561.method_43471("item.strangetools.smithing_template.apple_upgrade.applies_to")
                .method_27692(class_124.field_1078);
        class_2561 ingredients = class_2561.method_43471("item.strangetools.smithing_template.apple_upgrade.ingredients")
                .method_27692(class_124.field_1078);
        class_2561 title = class_2561.method_43471("upgrade.strangetools.apple_upgrade")
                .method_27692(class_124.field_1080);
        class_2561 baseSlotDesc = class_2561.method_43471("item.strangetools.smithing_template.apple_upgrade.base_slot_description");
        class_2561 additionsSlotDesc = class_2561.method_43471("item.strangetools.smithing_template.apple_upgrade.additions_slot_description");

        // 基础槽位的空图标
        List<class_2960> emptyBaseSlots = List.of(
                new class_2960("item/empty_armor_slot_helmet"),
                new class_2960("item/empty_slot_sword"),
                new class_2960("item/empty_armor_slot_chestplate"),
                new class_2960("item/empty_slot_pickaxe"),
                new class_2960("item/empty_armor_slot_leggings"),
                new class_2960("item/empty_slot_axe"),
                new class_2960("item/empty_armor_slot_boots"),
                new class_2960("item/empty_slot_hoe"),
                new class_2960("item/empty_slot_shovel")
        );

        // 附加槽位的空图标
        List<class_2960> emptyAdditionsSlots = List.of(
                new class_2960("item/empty_slot_ingot")
        );

        return new class_8052(
                appliesTo,
                ingredients,
                title,
                baseSlotDesc,
                additionsSlotDesc,
                emptyBaseSlots,
                emptyAdditionsSlots
        ) {
            @Override
            public String method_7876() {
                return "item.strangetools.apple_upgrade_smithing_template";
            }
        };
    }
}
