package com.stools.item;

import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class ModTrades {
    // 主世界工具
    private static final List<String> MAIN_WORLD_MATERIALS = Arrays.asList(
            "dirt", "copper", "emerald", "lapis", "redstone", "coal",
            "obsidian", "prismarine", "rotten_flesh",
            "bone", "glass", "slime", "string", "amethyst", "flint","blue_ice"
    );

    // 盔甲材料
    private static final List<String> ARMOR_MATERIALS = Arrays.asList(
            "copper", "emerald", "lapis", "redstone"
    );

    // 工具类型
    private static final List<String> TOOL_TYPES = Arrays.asList(
            "sword", "pickaxe", "axe", "shovel", "hoe"
    );

    public static void registerTrades() {
        registerToolsmithTrades();
        registerArmorerTrades();
        registerWanderingTraderTrades();
    }

    private static void registerToolsmithTrades() {
        // 工具匠等级1-2交易（低级工具）
        TradeOfferHelper.registerVillagerOffers(class_3852.field_17064, 1, factories -> {
            addToolsForMaterials(factories, Arrays.asList("dirt", "coal", "string", "rotten_flesh", "flint"), 1, 4);
        });

        // 工具匠等级3交易（中级工具）
        TradeOfferHelper.registerVillagerOffers(class_3852.field_17064, 3, factories -> {
            addToolsForMaterials(factories, Arrays.asList("copper", "lapis", "redstone", "bone", "slime", "glass","blue_ice"), 3, 7);
        });

        // 工具匠等级4-5交易（高级工具）
        TradeOfferHelper.registerVillagerOffers(class_3852.field_17064, 5, factories -> {
            addToolsForMaterials(factories, Arrays.asList("emerald", "obsidian", "prismarine", "amethyst"), 5, 12);
        });
    }

    private static void addToolsForMaterials(List<class_3853.class_1652> factories, List<String> materials, int baseEmeralds, int maxUses) {
        for (String material : materials) {
            if (!MAIN_WORLD_MATERIALS.contains(material)) continue;

            for (String toolType : TOOL_TYPES) {
                String toolId = material + "_" + toolType;
                class_1792 tool = ModItems.TOOLS.get(toolId);
                if (tool != null) {
                    // 根据工具类型调整价格
                    final int emeraldCount;
                    if (toolType.equals("axe") || toolType.equals("sword")) {
                        emeraldCount = baseEmeralds + 2; // 战斗工具更贵
                    } else {
                        emeraldCount = baseEmeralds;
                    }

                    factories.add((entity, random) -> new class_1914(
                            new class_1799(class_1802.field_8687, emeraldCount),
                            new class_1799(tool),
                            maxUses, // 最大交易次数
                            8, // 经验值
                            0.05f // 价格乘数
                    ));
                }
            }
        }
    }

    private static void registerArmorerTrades() {
        // 盔甲匠等级1交易（低级盔甲）
        TradeOfferHelper.registerVillagerOffers(class_3852.field_17052, 1, factories -> {
            addArmorForMaterial(factories, "copper", 4, 8);
        });

        // 盔甲匠等级2交易（中级盔甲）
        TradeOfferHelper.registerVillagerOffers(class_3852.field_17052, 2, factories -> {
            addArmorForMaterial(factories, "redstone", 6, 10);
        });

        // 盔甲匠等级3交易（高级盔甲）
        TradeOfferHelper.registerVillagerOffers(class_3852.field_17052, 3, factories -> {
            addArmorForMaterial(factories, "lapis", 8, 12);
        });

        // 盔甲匠等级4-5交易（顶级盔甲）
        TradeOfferHelper.registerVillagerOffers(class_3852.field_17052, 5, factories -> {
            addArmorForMaterial(factories, "emerald", 12, 15);
        });
    }

    private static void addArmorForMaterial(List<class_3853.class_1652> factories, String material, int baseEmeralds, int maxUses) {
        if (!ARMOR_MATERIALS.contains(material)) return;

        String[] armorTypes = {"helmet", "chestplate", "leggings", "boots"};
        for (String armorType : armorTypes) {
            String armorId = material + "_" + armorType;
            class_1792 armor = ModItems.ARMORS.get(armorId);
            if (armor != null) {
                final int emeraldCount;
                // 胸甲最贵，然后是头盔和护腿，靴子最便宜
                if (armorType.equals("chestplate")) {
                    emeraldCount = baseEmeralds + 3;
                } else if (armorType.equals("helmet") || armorType.equals("leggings")) {
                    emeraldCount = baseEmeralds + 1;
                } else {
                    emeraldCount = baseEmeralds;
                }

                factories.add((entity, random) -> new class_1914(
                        new class_1799(class_1802.field_8687, emeraldCount),
                        new class_1799(armor),
                        maxUses,
                        10, // 经验值
                        0.05f
                ));
            }
        }
    }

    private static void registerWanderingTraderTrades() {
        // 流浪商人出售特殊工具（较低概率）
        TradeOfferHelper.registerWanderingTraderOffers(1, factories -> {
            factories.add((entity, random) -> {
                // 随机选择一个主世界工具
                String material = MAIN_WORLD_MATERIALS.get(random.method_43048(MAIN_WORLD_MATERIALS.size()));
                String toolType = TOOL_TYPES.get(random.method_43048(TOOL_TYPES.size()));
                String toolId = material + "_" + toolType;

                class_1792 tool = ModItems.TOOLS.get(toolId);
                if (tool == null) return null;

                // 随机价格（3-8个绿宝石）
                int emeraldCount = 3 + random.method_43048(6);

                return new class_1914(
                        new class_1799(class_1802.field_8687, emeraldCount),
                        new class_1799(tool),
                        3, // 最大交易次数
                        5, // 经验值
                        0.1f // 价格乘数
                );
            });

            // 添加一些特殊盔甲交易（较低概率）
            factories.add((entity, random) -> {
                if (random.method_43057() < 0.3f) { // 30% 概率
                    String material = ARMOR_MATERIALS.get(random.method_43048(ARMOR_MATERIALS.size()));
                    String armorType = new String[]{"helmet", "chestplate", "leggings", "boots"}[random.method_43048(4)];
                    String armorId = material + "_" + armorType;

                    class_1792 armor = ModItems.ARMORS.get(armorId);
                    if (armor == null) return null;

                    int emeraldCount = 8 + random.method_43048(8); // 8-15个绿宝石

                    return new class_1914(
                            new class_1799(class_1802.field_8687, emeraldCount),
                            new class_1799(armor),
                            2, // 最大交易次数
                            8, // 经验值
                            0.1f
                    );
                }
                return null;
            });
        });
    }
}