package com.stools.render.entity;

import com.stools.entity.EnderPhantomEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5605;
import net.minecraft.class_5607;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_897;

public class EnderPhantomRenderer extends class_897<EnderPhantomEntity> {
    public EnderPhantomRenderer(class_5617.class_5618 ctx) {
        super(ctx);
    }

    @Override
    public void render(EnderPhantomEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        // 添加空检查 - 确保UUID不为null
        if (entity.getPlayerUuid() == null) {
            return;
        }

        class_1657 player = entity.method_37908().method_18470(entity.getPlayerUuid());
        if (player == null) return;

        // 直接使用玩家皮肤纹理
        class_2960 skinTexture = class_310.method_1551().method_1582().method_44705(player.method_7334());

        // 使用Steve模型（粗手臂
        class_591<class_1657> model = new class_591<>(
                class_5607.method_32110(class_591.method_32028(class_5605.field_27715, false), 64, 64)
                        .method_32109(),
                false // 不是slim模型
        );

        matrices.method_22903();
        matrices.method_22904(0, 0.1, 0); // 稍微浮空
        matrices.method_22905(1.02f, 1.02f, 1.02f); // 比玩家稍大

        // 渲染玩家模型（只渲染皮肤）
        renderSimplePlayerModel(model, player, tickDelta, matrices, vertexConsumers, light, skinTexture);
        matrices.method_22909();
    }

    private void renderSimplePlayerModel(
            class_591<class_1657> model,
            class_1657 entity,
            float tickDelta,
            class_4587 matrices,
            class_4597 vertexConsumers,
            int light,
            class_2960 texture) {

        // 设置模型角度和动画
        float limbAngle = entity.field_42108.method_48569();
        float limbDistance = entity.field_42108.method_48566();
        model.method_17087(entity, limbAngle, limbDistance, entity.field_6012 + tickDelta, entity.field_6241, entity.method_36455());

        // 创建半透明顶点消费者
        class_4588 translucentVertexConsumer = vertexConsumers.getBuffer(
                class_1921.method_23580(texture)
        );

        // 只渲染身体部分（不渲染盔甲和手部物品）
        matrices.method_22903();
        matrices.method_22905(-1.0F, -1.0F, 1.0F);
        matrices.method_22904(0.0D, -1.501F, 0.0D);

        // 渲染各个身体部位（只渲染皮肤）
        model.field_3398.method_22699(matrices, translucentVertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 0.7f);
        model.field_3391.method_22699(matrices, translucentVertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 0.7f);
        model.field_3401.method_22699(matrices, translucentVertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 0.7f);
        model.field_27433.method_22699(matrices, translucentVertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 0.7f);
        model.field_3392.method_22699(matrices, translucentVertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 0.7f);
        model.field_3397.method_22699(matrices, translucentVertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 0.7f);

        // 渲染帽子层
        matrices.method_22903();
        matrices.method_22905(1.01f, 1.01f, 1.01f); // 稍微放大以覆盖底层
        model.field_3394.method_22699(matrices, translucentVertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 0.7f);
        matrices.method_22909();

        matrices.method_22909();
    }

    @Override
    public class_2960 getTexture(EnderPhantomEntity entity) {
        return null; // 使用玩家皮肤，不需要单独纹理
    }
}