/*
 * Decompiled with CFR 0.152.
 */
package com.stools.event;

import com.stools.config.ModConfigManager;
import com.stools.item.materials.ModArmorMaterials;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_8103;
import org.joml.Vector3f;

public class ArmorEffectHandler {
    private static final Map<ModArmorMaterials, List<class_1293>> ARMOR_EFFECTS_MAP = new EnumMap<ModArmorMaterials, List<class_1293>>(ModArmorMaterials.class);
    private static final Random RANDOM;

    public static void register() {
        ArmorEffectHandler.initArmorEffects();
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills || !ModConfigManager.CONFIG.armorEffects.enableArmorEffects) {
                return true;
            }
            if (source.method_48789(class_8103.field_42249) && ArmorEffectHandler.hasAnyObsidianArmor(entity)) {
                for (class_1799 armor : entity.method_5661()) {
                    if (!ArmorEffectHandler.isObsidianArmor(armor)) continue;
                    int maxDamage = armor.method_7936();
                    int damageToApply = maxDamage / 10;
                    armor.method_7974(armor.method_7919() + damageToApply);
                    if (armor.method_7919() < maxDamage) continue;
                    armor.method_7934(1);
                }
                class_1937 patt0$temp = entity.method_37908();
                if (patt0$temp instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)patt0$temp;
                    serverWorld.method_14199((class_2394)class_2398.field_11237, entity.method_23317(), entity.method_23318() + 1.0, entity.method_23321(), 20, 0.5, 0.5, 0.5, 0.1);
                    serverWorld.method_8396(null, entity.method_24515(), class_3417.field_14785, class_3419.field_15248, 0.8f, 0.5f);
                }
                return false;
            }
            class_1297 patt0$temp = source.method_5529();
            if (patt0$temp instanceof class_1309) {
                class_1309 attacker = (class_1309)patt0$temp;
                ArmorEffectHandler.applyReflectiveDamage(entity, attacker, amount);
            }
            return true;
        });
        ServerTickEvents.START_WORLD_TICK.register(world -> {
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills || !ModConfigManager.CONFIG.armorEffects.enableArmorEffects) {
                return;
            }
            if (!(world instanceof class_3218)) {
                return;
            }
            for (class_1657 player : world.method_18456()) {
                if (!(player instanceof class_3222)) continue;
                ArmorEffectHandler.applyContinuousEffects(player);
                ArmorEffectHandler.applyObsidianFullSetEffects(player);
            }
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
            if (!ModConfigManager.CONFIG.toolEffects.enableToolSkills || !ModConfigManager.CONFIG.armorEffects.enableArmorEffects) {
                return;
            }
            ArmorEffectHandler.applyContinuousEffects((class_1657)player);
        });
    }

    private static void initArmorEffects() {
    }

    private static void applyReflectiveDamage(class_1309 wearer, class_1309 attacker, float damageAmount) {
        class_1792 class_17922;
        int coalArmorCount = 0;
        for (class_1799 armor : wearer.method_5661()) {
            class_1738 armorItem;
            class_17922 = armor.method_7909();
            if (!(class_17922 instanceof class_1738) || (armorItem = (class_1738)class_17922).method_7686() != ModArmorMaterials.COAL) continue;
            ++coalArmorCount;
        }
        if (coalArmorCount > 0) {
            float igniteChance = 0.15f + (float)coalArmorCount * 0.05f;
            if (RANDOM.nextFloat() < igniteChance) {
                int fireTime = 1 + RANDOM.nextInt(3);
                attacker.method_5639(fireTime * 20);
                class_17922 = wearer.method_37908();
                if (class_17922 instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_17922;
                    serverWorld.method_14199((class_2394)class_2398.field_11240, attacker.method_23317(), attacker.method_23318() + 1.0, attacker.method_23321(), 10, 0.3, 0.3, 0.3, 0.05);
                }
            }
        }
        Enum fullSetMaterial = null;
        class_1799 headStack = wearer.method_6118(class_1304.field_6169);
        ModArmorMaterials headMaterial = ArmorEffectHandler.getArmorMaterial(headStack);
        class_1799 chestStack = wearer.method_6118(class_1304.field_6174);
        ModArmorMaterials chestMaterial = ArmorEffectHandler.getArmorMaterial(chestStack);
        class_1799 legsStack = wearer.method_6118(class_1304.field_6172);
        ModArmorMaterials legsMaterial = ArmorEffectHandler.getArmorMaterial(legsStack);
        class_1799 feetStack = wearer.method_6118(class_1304.field_6166);
        ModArmorMaterials feetMaterial = ArmorEffectHandler.getArmorMaterial(feetStack);
        if (headMaterial != null && headMaterial != ModArmorMaterials.COAL && headMaterial == chestMaterial && headMaterial == legsMaterial && headMaterial == feetMaterial) {
            fullSetMaterial = headMaterial;
        }
        if (fullSetMaterial == null) {
            return;
        }
        switch (1.$SwitchMap$com$stools$item$materials$ModArmorMaterials[fullSetMaterial.ordinal()]) {
            case 1: {
                float dropChance = ModConfigManager.CONFIG.armorEffects.emeraldDropBaseChance / 100.0f;
                dropChance += damageAmount * 0.01f;
                dropChance = Math.min(dropChance, 0.5f);
                if (!(wearer.method_6051().method_43057() < dropChance)) break;
                int dropCount = Math.max(1, (int)(damageAmount * ModConfigManager.CONFIG.armorEffects.emeraldDamageMultiplier));
                dropCount = Math.min(dropCount, 5);
                class_1937 class_19372 = wearer.method_37908();
                if (!(class_19372 instanceof class_3218)) break;
                class_3218 serverWorld = (class_3218)class_19372;
                class_1542 emeraldDrop = new class_1542((class_1937)serverWorld, wearer.method_23317(), wearer.method_23318() + 0.5, wearer.method_23321(), new class_1799((class_1935)class_1802.field_8687, dropCount));
                serverWorld.method_8649((class_1297)emeraldDrop);
                serverWorld.method_14199((class_2394)class_2398.field_11211, wearer.method_23317(), wearer.method_23318() + 1.5, wearer.method_23321(), 15, 0.5, 0.5, 0.5, 0.1);
                serverWorld.method_8396(null, wearer.method_24515(), class_3417.field_14627, class_3419.field_15248, 0.8f, 1.2f);
                break;
            }
            case 2: {
                float xpStealChance = 0.3f;
                if (!(wearer.method_6051().method_43057() < xpStealChance)) break;
                int stolenXp = 1 + RANDOM.nextInt(3);
                if (attacker instanceof class_1657) {
                    ((class_1657)attacker).method_7255(-stolenXp);
                }
                if (!(wearer instanceof class_1657)) break;
                ((class_1657)wearer).method_7255(stolenXp);
                class_1937 class_19373 = wearer.method_37908();
                if (!(class_19373 instanceof class_3218)) break;
                class_3218 serverWorld = (class_3218)class_19373;
                serverWorld.method_14199((class_2394)class_2398.field_11215, wearer.method_23317(), wearer.method_23318() + 1.5, wearer.method_23321(), 10, 0.5, 0.5, 0.5, 0.1);
                break;
            }
            case 3: {
                if (wearer.method_37908().method_8546()) {
                    float lightningChance = ModConfigManager.CONFIG.armorEffects.copperPushChance / 100.0f;
                    if (RANDOM.nextFloat() < lightningChance) {
                        attacker.method_6005(0.5, wearer.method_23317() - attacker.method_23317(), wearer.method_23321() - attacker.method_23321());
                        wearer.method_37908().method_8396(null, attacker.method_24515(), class_3417.field_14865, class_3419.field_15248, 0.5f, 1.5f);
                    }
                }
                float cleanseChance = ModConfigManager.CONFIG.armorEffects.copperCleanseChance / 100.0f;
                if (!(RANDOM.nextFloat() < cleanseChance)) break;
                Optional<class_1291> effectToRemove = wearer.method_6088().keySet().stream().filter(effect -> !effect.method_5573()).findAny();
                effectToRemove.ifPresent(effect -> {
                    wearer.method_6016(effect);
                    class_1937 patt0$temp = wearer.method_37908();
                    if (patt0$temp instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)patt0$temp;
                        serverWorld.method_14199((class_2394)class_2398.field_11211, wearer.method_23317(), wearer.method_23318() + 1.5, wearer.method_23321(), 5, 0.3, 0.3, 0.3, 0.1);
                    }
                });
                break;
            }
            case 4: {
                float slowChance = 0.12f;
                if (RANDOM.nextFloat() < slowChance) {
                    attacker.method_6092(new class_1293(class_1294.field_5909, 40, 0, false, false, true));
                    class_1937 class_19374 = wearer.method_37908();
                    if (class_19374 instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)class_19374;
                        class_2390 dustEffect = new class_2390(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f);
                        serverWorld.method_14199((class_2394)dustEffect, attacker.method_23317(), attacker.method_23318() + 1.0, attacker.method_23321(), 5, 0.3, 0.3, 0.3, 0.1);
                    }
                }
                float repairChance = 0.15f;
                if (!(RANDOM.nextFloat() < repairChance)) break;
                for (class_1799 armor : wearer.method_5661()) {
                    if (!armor.method_7986()) continue;
                    armor.method_7974(armor.method_7919() - 1);
                }
                wearer.method_37908().method_8396(null, wearer.method_24515(), class_3417.field_26980, class_3419.field_15248, 0.6f, 1.8f);
                break;
            }
            case 5: {
                float reflectChance = 0.15f;
                if (!(RANDOM.nextFloat() < reflectChance)) break;
                attacker.method_5643(attacker.method_48923().method_48818((class_1297)wearer), 3.0f);
                attacker.method_6005(0.5, wearer.method_23317() - attacker.method_23317(), wearer.method_23321() - attacker.method_23321());
                class_1937 class_19375 = wearer.method_37908();
                if (!(class_19375 instanceof class_3218)) break;
                class_3218 serverWorld = (class_3218)class_19375;
                serverWorld.method_14199((class_2394)class_2398.field_11205, attacker.method_23317(), attacker.method_23318() + 1.0, attacker.method_23321(), 10, 0.3, 0.3, 0.3, 0.1);
                serverWorld.method_8396(null, attacker.method_24515(), class_3417.field_15081, class_3419.field_15248, 0.8f, 1.2f);
            }
        }
    }

    private static ModArmorMaterials getArmorMaterial(class_1799 stack) {
        class_1738 armorItem;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1738 && (class_17922 = (armorItem = (class_1738)class_17922).method_7686()) instanceof ModArmorMaterials) {
            ModArmorMaterials mat = (ModArmorMaterials)class_17922;
            return mat;
        }
        return null;
    }

    private static boolean hasAnyObsidianArmor(class_1309 entity) {
        for (class_1799 armor : entity.method_5661()) {
            if (!ArmorEffectHandler.isObsidianArmor(armor)) continue;
            return true;
        }
        return false;
    }

    private static boolean isObsidianArmor(class_1799 stack) {
        class_1738 armorItem;
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof class_1738 && (armorItem = (class_1738)class_17922).method_7686() == ModArmorMaterials.OBSIDIAN;
    }

    private static void applyContinuousEffects(class_1657 player) {
        for (Map.Entry<ModArmorMaterials, List<class_1293>> entry : ARMOR_EFFECTS_MAP.entrySet()) {
            ModArmorMaterials material = entry.getKey();
            List<class_1293> effects = entry.getValue();
            if (!ArmorEffectHandler.hasFullSet(player, material)) continue;
            for (class_1293 effect : effects) {
                ArmorEffectHandler.applyEffectWithRefresh(player, effect);
            }
        }
    }

    private static void applyObsidianFullSetEffects(class_1657 player) {
        if (ArmorEffectHandler.hasFullSet(player, ModArmorMaterials.OBSIDIAN) && player.method_37908().method_8510() % 100L == 0L) {
            for (class_1799 armor : player.method_5661()) {
                if (!armor.method_7986() || !ArmorEffectHandler.isObsidianArmor(armor)) continue;
                armor.method_7974(armor.method_7919() - 1);
            }
        }
    }

    private static void applyEffectWithRefresh(class_1657 player, class_1293 effect) {
        class_1293 current = player.method_6112(effect.method_5579());
        if (current == null || current.method_5584() <= 10) {
            player.method_6092(new class_1293(effect.method_5579(), 20, effect.method_5578(), false, false, true));
        }
    }

    private static boolean hasFullSet(class_1657 player, ModArmorMaterials material) {
        return ArmorEffectHandler.isArmorOfMaterial(player.method_6118(class_1304.field_6169), material) && ArmorEffectHandler.isArmorOfMaterial(player.method_6118(class_1304.field_6174), material) && ArmorEffectHandler.isArmorOfMaterial(player.method_6118(class_1304.field_6172), material) && ArmorEffectHandler.isArmorOfMaterial(player.method_6118(class_1304.field_6166), material);
    }

    private static boolean isArmorOfMaterial(class_1799 stack, ModArmorMaterials material) {
        class_1738 armorItem;
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof class_1738 && (armorItem = (class_1738)class_17922).method_7686() == material;
    }

    static {
        ARMOR_EFFECTS_MAP.put(ModArmorMaterials.EMERALD, List.of(new class_1293(class_1294.field_5926, 100, 1, false, false, true)));
        ARMOR_EFFECTS_MAP.put(ModArmorMaterials.LAPIS, List.of(new class_1293(class_1294.field_5907, 100, 0, false, false, true)));
        ARMOR_EFFECTS_MAP.put(ModArmorMaterials.OBSIDIAN, List.of(new class_1293(class_1294.field_5907, 100, 0, false, false, true), new class_1293(class_1294.field_5909, 100, 0, false, false, true)));
        RANDOM = new Random();
    }
}

