/*
 * Decompiled with CFR 0.152.
 */
package com.createdimensions.content.registry;

import com.createdimensions.content.dimension.PocketDimensionWorldProperties;
import com.createdimensions.mixin.accessors.MinecraftServerAccessor;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListenerFactory;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.PathAllowList;

public class ModDimensions {
    static final LevelStorageSource LEVEL_STORAGE = new LevelStorageSource(Path.of("createdimension_saves", new String[0]), Path.of("createdimension_backups", new String[0]), new DirectoryValidator(new PathAllowList((List)ImmutableList.of())), DataFixers.m_14512_());
    public static final ResourceKey<DimensionType> POCKET_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)ResourceLocation.m_214293_((String)"createdimensions", (String)"pocket_dimension"));

    public static ServerLevel createWorld(MinecraftServer server, ResourceKey<Level> worldKey) throws IOException, ContentValidationException {
        ExecutorService executor = Util.m_183991_();
        LevelStorageSource.LevelStorageAccess storageSession = LEVEL_STORAGE.m_289864_("pocket");
        ChunkProgressListenerFactory progressListenerFactory = ((MinecraftServerAccessor)server).getWorldGenerationProgressListenerFactory();
        PocketDimensionWorldProperties worldProperties = new PocketDimensionWorldProperties();
        RegistryAccess registryManager = server.m_129783_().m_9598_();
        Registry dimensionTypeRegistry = registryManager.m_175515_(Registries.f_256787_);
        Registry biomeRegistry = registryManager.m_175515_(Registries.f_256952_);
        DimensionType dimensionType = (DimensionType)dimensionTypeRegistry.m_6246_(POCKET_DIMENSION);
        Biome biome = (Biome)biomeRegistry.m_6246_(Biomes.f_48173_);
        LevelStem dimensionOptions = new LevelStem(dimensionTypeRegistry.m_263177_((Object)dimensionType), (ChunkGenerator)new FlatLevelSource(new FlatLevelGeneratorSettings(Optional.of(HolderSet.m_205809_((Holder[])new Holder[0])), biomeRegistry.m_263177_((Object)biome), (List)ImmutableList.of())));
        ServerLevel serverWorld = new ServerLevel(server, (Executor)executor, storageSession, (ServerLevelData)worldProperties, worldKey, dimensionOptions, progressListenerFactory.m_9620_(11), false, 0L, (List)ImmutableList.of(), false, new RandomSequences(0L));
        ((MinecraftServerAccessor)server).getWorlds().put(worldKey, serverWorld);
        serverWorld.m_46597_(new BlockPos(0, 63, 0), Blocks.f_50752_.m_49966_());
        serverWorld.m_8793_(() -> true);
        return serverWorld;
    }

    public static void sendTo(MinecraftServer server, Player user, ResourceKey<Level> worldKey) {
        if (server.m_129784_().contains(worldKey)) {
            ServerLevel serverWorld = Objects.requireNonNull(server.m_129880_(worldKey));
            serverWorld.m_46961_(new BlockPos(0, 64, 0), true);
            serverWorld.m_46961_(new BlockPos(0, 65, 0), true);
            user.m_264318_(serverWorld, 0.5, 64.0, 0.5, Set.of(), user.m_146908_(), user.m_146909_());
        } else {
            try {
                ServerLevel serverWorld = ModDimensions.createWorld(server, worldKey);
                user.m_264318_(serverWorld, 0.5, 64.0, 0.5, Set.of(), user.m_146908_(), user.m_146909_());
            }
            catch (IOException | ContentValidationException throwable) {
                // empty catch block
            }
        }
    }
}

