/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.csfnaf.Block.BlockEntities;

import java.util.List;
import net.corespring.csfnaf.Block.Decorations.RuinScooperBlock;
import net.corespring.csfnaf.Registry.CSBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.RenderUtils;

public class RuinScooperBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean wasPowered = false;

    public RuinScooperBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)CSBlockEntities.RUIN_SCOOPER_BE.get(), pPos, pBlockState);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, RuinScooperBlockEntity scooperBlockEntity) {
        scooperBlockEntity.checkRedstone(pLevel, pPos, pState);
    }

    public void checkRedstone(Level pLevel, BlockPos pPos, BlockState state) {
        boolean isPowered = pLevel.m_276867_(pPos);
        if (isPowered && !this.wasPowered) {
            this.triggerAttack(pLevel, pPos, state);
            this.damageEntitiesInFront();
        }
        this.wasPowered = isPowered;
    }

    private void triggerAttack(Level pLevel, BlockPos pPos, BlockState pState) {
        if (!((Boolean)pState.m_61143_((Property)RuinScooperBlock.ATTACKING)).booleanValue()) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)RuinScooperBlock.ATTACKING, (Comparable)Boolean.valueOf(true)), 3);
            float pPitch = 0.8f + pLevel.f_46441_.m_188501_() * 0.4f;
            pLevel.m_5594_(null, pPos, SoundEvents.f_12312_, SoundSource.BLOCKS, 0.5f, pPitch);
            pLevel.m_5594_(null, pPos, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.5f, pPitch);
            pLevel.m_5594_(null, pPos, SoundEvents.f_12009_, SoundSource.BLOCKS, 0.5f, pPitch);
            pLevel.m_186460_(pPos, pState.m_60734_(), 30);
        }
    }

    public void resetAttackState() {
        if (this.f_58857_ != null && ((Boolean)this.m_58900_().m_61143_((Property)RuinScooperBlock.ATTACKING)).booleanValue()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)RuinScooperBlock.ATTACKING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private void damageEntitiesInFront() {
        if (this.f_58857_ == null) {
            return;
        }
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)RuinScooperBlock.FACING);
        BlockPos startPos = this.f_58858_.m_121945_(direction);
        BlockPos endPos = startPos.m_5484_(direction, 2);
        AABB damageArea = new AABB((double)Math.min(startPos.m_123341_(), endPos.m_123341_()), (double)this.f_58858_.m_123342_(), (double)Math.min(startPos.m_123343_(), endPos.m_123343_()), (double)(Math.max(startPos.m_123341_(), endPos.m_123341_()) + 1), (double)(this.f_58858_.m_123342_() + 2), (double)(Math.max(startPos.m_123343_(), endPos.m_123343_()) + 1));
        List entities = this.f_58857_.m_45976_(LivingEntity.class, damageArea);
        for (LivingEntity entity : entities) {
            entity.m_6469_(entity.m_269291_().m_269264_(), 1.0f);
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128379_("wasPowered", this.wasPowered);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.wasPowered = pTag.m_128471_("wasPowered");
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> state) {
        if (((Boolean)this.m_58900_().m_61143_((Property)RuinScooperBlock.ATTACKING)).booleanValue()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("scoop"));
            return PlayState.CONTINUE;
        }
        state.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }
}

