/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.csfnaf.Entity.Armors;

import net.corespring.csfnaf.Registry.CSEffects;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class SpringlockArmorItem
extends ArmorItem
implements GeoItem {
    private static final int BLEEDING_MAX_AMPLIFIER = 10;
    private static final int BASE_BLEEDING_DURATION = 600;
    private static final int STRONG_BLEEDING_DURATION = 1200;
    private static final int CRITICAL_BLEEDING_DURATION = 48000;
    private static final float WATER_TRIGGER_CHANCE = 0.1f;
    private static final float RANDOM_BLEEDING_CHANCE = 0.005f;
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public SpringlockArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void onArmorTick(ItemStack pStack, Level pLevel, Player pPlayer) {
        if (pLevel.m_5776_() || pPlayer.m_7500_() || pPlayer.m_5833_()) {
            return;
        }
        if (this.hasFullSuitOfArmorOn(pPlayer)) {
            if (!pPlayer.m_21023_(CSEffects.CALIBRATED.get())) {
                this.applyArmorEffect(pPlayer);
                if (this.isPlayerExposedToWater(pPlayer, pLevel)) {
                    this.handleWaterExposure(pPlayer);
                }
                this.handleRandomBleedingIncrease(pLevel, pPlayer);
            }
        } else {
            pPlayer.m_21195_(CSEffects.CALIBRATED.get());
            this.handlePartialSuitEffects(pPlayer);
        }
    }

    private void handleWaterExposure(Player pPlayer) {
        MobEffectInstance existingBleeding = pPlayer.m_21124_(CSEffects.BLEEDING.get());
        int newAmplifier = 0;
        if (existingBleeding != null) {
            newAmplifier = Math.min(existingBleeding.m_19564_() + 2, 10);
        }
        pPlayer.m_7292_(new MobEffectInstance(CSEffects.BLEEDING.get(), 600, newAmplifier, false, true));
        if (pPlayer.m_217043_().m_188501_() < 0.1f) {
            pPlayer.m_7292_(new MobEffectInstance(CSEffects.BLEEDING.get(), 1200, 5, false, true));
        }
    }

    private void handleRandomBleedingIncrease(Level pLevel, Player pPlayer) {
        MobEffectInstance currentBleeding = pPlayer.m_21124_(CSEffects.BLEEDING.get());
        if (currentBleeding == null || currentBleeding.m_19557_() <= 100) {
            return;
        }
        if (pLevel.f_46441_.m_188501_() < 0.005f) {
            pPlayer.m_7292_(new MobEffectInstance(CSEffects.BLEEDING.get(), currentBleeding.m_19557_() + 200, Math.min(currentBleeding.m_19564_() + 1, 10), false, true));
        }
    }

    private void handlePartialSuitEffects(Player pPlayer) {
        MobEffectInstance bleeding = pPlayer.m_21124_(CSEffects.BLEEDING.get());
        if (bleeding == null || bleeding.m_19564_() <= 3) {
            return;
        }
        pPlayer.m_7911_(0.0f);
        pPlayer.m_36324_().m_38705_(Math.min(pPlayer.m_36324_().m_38702_(), 6));
    }

    private boolean isPlayerExposedToWater(Player pPlayer, Level pLevel) {
        if (pPlayer.m_20069_() || pPlayer.m_20071_()) {
            return true;
        }
        if (pLevel.m_46758_(pPlayer.m_20183_()) || pLevel.m_46758_(pPlayer.m_20183_().m_7494_())) {
            return pLevel.m_45527_(pPlayer.m_20183_()) || pLevel.m_45527_(pPlayer.m_20183_().m_7494_());
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (pLevel.m_8055_(pPlayer.m_20183_().m_7918_(x, 0, z)).m_60819_().m_76178_()) continue;
                return true;
            }
        }
        return false;
    }

    private void applyArmorEffect(Player pPlayer) {
        MobEffectInstance sweating = pPlayer.m_21124_(CSEffects.SWEATING.get());
        if (sweating == null) {
            pPlayer.m_7292_(new MobEffectInstance(CSEffects.SWEATING.get(), 600, 0, false, false));
        } else if (sweating.m_19564_() == 0 && sweating.m_19557_() <= 40) {
            pPlayer.m_7292_(new MobEffectInstance(CSEffects.SWEATING.get(), 1200, 1, false, false));
        } else if (sweating.m_19564_() == 1 && sweating.m_19557_() <= 40) {
            pPlayer.m_7292_(new MobEffectInstance(CSEffects.BLEEDING.get(), 120, 2, false, true));
        }
        this.handleCriticalBleeding(pPlayer);
    }

    private void handleCriticalBleeding(Player pPlayer) {
        MobEffectInstance bleeding = pPlayer.m_21124_(CSEffects.BLEEDING.get());
        if (bleeding == null || bleeding.m_19557_() > 40 || bleeding.m_19564_() < 2) {
            return;
        }
        int newAmplifier = Math.min(bleeding.m_19564_() * 2, 10);
        pPlayer.m_7292_(new MobEffectInstance(CSEffects.BLEEDING.get(), 48000, newAmplifier, false, true));
    }

    private boolean hasFullSuitOfArmorOn(Player pPlayer) {
        for (ItemStack armorStack : pPlayer.m_150109_().f_35975_) {
            if (!armorStack.m_41619_() && armorStack.m_41720_() instanceof SpringlockArmorItem) continue;
            return false;
        }
        return true;
    }
}

