/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.csfnaf.Entity.Presets;

import javax.annotation.Nullable;
import net.corespring.csfnaf.Util.Rotatable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public abstract class StandAnimatronic
extends PathfinderMob
implements GeoEntity,
Rotatable {
    private static final String IDLE_ANIMATION = "idle";
    private static final int TRANSITION_TICKS = 4;
    private static final float ROTATION_LOCK = 45.0f;
    private static final ResourceLocation HURT_SOUND = new ResourceLocation("entity.iron_golem.hurt");
    private static final ResourceLocation DEATH_SOUND = new ResourceLocation("block.anvil.destroy");
    private static final SoundEvent FALLBACK_HURT_SOUND = SoundEvents.f_12008_;
    private static final SoundEvent FALLBACK_DEATH_SOUND = SoundEvents.f_11668_;
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public StandAnimatronic(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22265_();
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        tAnimationState.getController().setAnimation(RawAnimation.begin().then(IDLE_ANIMATION, Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void rotate(float angle) {
        float currentYaw = this.m_146908_();
        float newYaw = currentYaw + angle;
        this.m_146922_(newYaw);
        this.f_19859_ = newYaw;
        this.f_20885_ = newYaw;
        this.f_20883_ = newYaw;
    }

    public boolean m_6094_() {
        return false;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pData, @Nullable CompoundTag pTag) {
        super.m_6518_(pLevel, pDifficulty, pReason, pData, pTag);
        Player player = pLevel.m_45930_((Entity)this, 5.0);
        if (player != null) {
            this.facePlayer(player);
        }
        return pData;
    }

    private void facePlayer(Player player) {
        double dx = player.m_20185_() - this.m_20185_();
        double dz = player.m_20189_() - this.m_20189_();
        float angle = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
        angle = (float)Math.round(angle / 45.0f) * 45.0f;
        angle = Mth.m_14177_((float)angle);
        this.m_146922_(angle);
        this.f_19859_ = angle;
        this.f_20885_ = angle;
        this.f_20883_ = angle;
    }

    public SoundEvent m_7975_(DamageSource pDamageSource) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(HURT_SOUND);
        return sound != null ? sound : FALLBACK_HURT_SOUND;
    }

    public SoundEvent m_5592_() {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(DEATH_SOUND);
        return sound != null ? sound : FALLBACK_DEATH_SOUND;
    }
}

