/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.csfnaf.Item;

import java.util.List;
import net.corespring.csfnaf.Entity.Armors.SpringlockArmorItem;
import net.corespring.csfnaf.Registry.CSEffects;
import net.corespring.csfnaf.Util.Rotatable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class HandCrankItem
extends Item {
    private static final int MAX_CALIBRATION_DURATION = 6000;
    private static final int CALIBRATION_PER_WIND = 400;
    private static final int COOLDOWN_TICKS = 10;

    public HandCrankItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.m_21120_(pUsedHand);
        if (this.isWearingSpringlockSuit(pPlayer)) {
            if (!pLevel.m_5776_()) {
                int currentDuration = pPlayer.m_21023_(CSEffects.CALIBRATED.get()) ? pPlayer.m_21124_(CSEffects.CALIBRATED.get()).m_19557_() : 0;
                int newDuration = Math.min(currentDuration + 400, 6000);
                pPlayer.m_7292_(new MobEffectInstance(CSEffects.CALIBRATED.get(), newDuration, 0, false, false));
                pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12013_, SoundSource.PLAYERS, 0.5f, 0.8f + pLevel.f_46441_.m_188501_() * 0.4f);
                pPlayer.m_36335_().m_41524_((Item)this, 10);
                if (newDuration >= 6000) {
                    pPlayer.m_5661_((Component)Component.m_237115_((String)"message.csfnaf.calibration.max").m_130940_(ChatFormatting.GREEN), true);
                } else {
                    pPlayer.m_5661_((Component)Component.m_237110_((String)"message.csfnaf.calibration.add", (Object[])new Object[]{20}).m_130940_(ChatFormatting.RED), true);
                }
            }
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public InteractionResult m_6880_(ItemStack pStack, Player pPlayer, LivingEntity pInteractionTarget, InteractionHand pUsedHand) {
        Level pLevel = pPlayer.m_9236_();
        if (!pLevel.m_5776_() && pInteractionTarget instanceof Mob && pInteractionTarget instanceof Rotatable) {
            Mob newEntity;
            Mob mob = (Mob)pInteractionTarget;
            EntityType<?> oppositeType = this.getOppositeEntityType(mob.m_6095_());
            EntityType originalType = mob.m_6095_();
            float currentRotation = 0.0f;
            if (oppositeType != null && !oppositeType.equals((Object)originalType) && (newEntity = (Mob)oppositeType.m_20615_(pLevel)) != null && newEntity.m_6095_().equals(oppositeType)) {
                newEntity.m_20359_((Entity)mob);
                newEntity.m_5618_(mob.m_146908_());
                newEntity.m_5616_(mob.m_6080_());
                newEntity.m_146926_(mob.m_146909_());
                newEntity.m_146922_(mob.m_146908_());
                if (newEntity instanceof Rotatable) {
                    ((Rotatable)newEntity).rotate(currentRotation);
                }
                newEntity.m_6518_((ServerLevelAccessor)pLevel, pLevel.m_6436_(newEntity.m_20183_()), MobSpawnType.CONVERSION, null, null);
                mob.m_146870_();
                pLevel.m_7967_((Entity)newEntity);
                pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12013_, SoundSource.PLAYERS, 0.5f, 0.8f + pLevel.f_46441_.m_188501_() * 0.4f);
                pLevel.m_220400_((Entity)pPlayer, GameEvent.f_223708_, pInteractionTarget.m_20182_());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private boolean isWearingSpringlockSuit(Player pPlayer) {
        for (ItemStack armorStack : pPlayer.m_150109_().f_35975_) {
            if (!(armorStack.m_41720_() instanceof SpringlockArmorItem)) continue;
            return true;
        }
        return false;
    }

    private EntityType<?> getOppositeEntityType(EntityType<?> currentType) {
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey(currentType);
        if (entityId == null) {
            return null;
        }
        String path = entityId.m_135815_();
        Object oppositePath = path.startsWith("s_") ? path.substring(2) : "s_" + path;
        ResourceLocation oppositeId = new ResourceLocation(entityId.m_135827_(), (String)oppositePath);
        EntityType oppositeType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(oppositeId);
        if (oppositeType != null && !oppositeType.m_20675_().contains("entity.minecraft.pig")) {
            return oppositeType;
        }
        return null;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.csfnaf.hand_crank").m_130940_(ChatFormatting.GOLD));
    }
}

