/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.csfnaf.Util;

import java.util.HashMap;
import java.util.Map;
import net.corespring.csfnaf.Registry.CSBlocks;
import net.corespring.csfnaf.Registry.CSEntities;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class NameRegenerator {
    private static final Map<String, String> PREFIX_RULES = new HashMap<String, String>(){
        {
            this.put("nunwithered", "n_unwithered");
            this.put("nglamrock", "n_glamrock");
            this.put("sitting_", "s_");
            this.put("golden_freddy", "classic_golden_freddy");
            this.put("freddy", "classic_freddy");
            this.put("chica", "classic_chica");
            this.put("bonnie", "classic_bonnie");
            this.put("foxy", "classic_foxy");
            this.put("plush_", "plush_classic_");
            this.put("poster_", "poster_classic_");
            this.put("head_", "head_classic_");
            this.put("faz_coin", "faz_token");
            this.put("wall_pizza", "wall_pizza_pepperoni");
        }
    };

    public static Map<String, EntityType<?>> generateEntityRenames() {
        HashMap mappings = new HashMap();
        for (RegistryObject entry : CSEntities.ENTITY_TYPES.getEntries()) {
            String newName = entry.getId().m_135815_();
            for (Map.Entry<String, String> rule : PREFIX_RULES.entrySet()) {
                if (!newName.startsWith(rule.getValue())) continue;
                String oldName = newName.replace(rule.getValue(), rule.getKey());
                mappings.put(oldName, (EntityType)entry.get());
            }
        }
        return mappings;
    }

    public static Map<String, Block> generateBlockRenames() {
        HashMap<String, Block> mappings = new HashMap<String, Block>();
        for (RegistryObject entry : CSBlocks.BLOCKS.getEntries()) {
            String newName = entry.getId().m_135815_();
            for (Map.Entry<String, String> rule : PREFIX_RULES.entrySet()) {
                if (!newName.startsWith(rule.getValue())) continue;
                String oldName = newName.replace(rule.getValue(), rule.getKey());
                mappings.put(oldName, (Block)entry.get());
            }
        }
        return mappings;
    }
}

