/*
 * Decompiled with CFR 0.152.
 */
package net.corespring.csfnaf.Util;

import java.util.List;
import java.util.Optional;
import net.corespring.csfnaf.Util.Rotatable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RotationHandler {
    private final float angle;

    public RotationHandler(float angle) {
        this.angle = angle;
    }

    public void rotateEntity(Player player) {
        Entity targetEntity = this.getEntityPlayerIsLookingAt(player);
        if (targetEntity != null && targetEntity instanceof Rotatable) {
            ((Rotatable)targetEntity).rotate(this.angle);
        }
    }

    private Entity getEntityPlayerIsLookingAt(Player player) {
        double reachDistance = 5.0;
        Vec3 eyePosition = player.m_20299_(1.0f);
        Vec3 lookVector = player.m_20252_(1.0f);
        Vec3 reachEnd = eyePosition.m_82549_(lookVector.m_82490_(reachDistance));
        AABB boundingBox = new AABB(eyePosition, reachEnd);
        List entities = player.m_9236_().m_45976_(Entity.class, boundingBox);
        Entity closestEntity = null;
        double closestDistance = reachDistance;
        for (Entity entity : entities) {
            double distance;
            AABB entityBoundingBox = entity.m_20191_().m_82400_(0.5);
            Optional hitResult = entityBoundingBox.m_82371_(eyePosition, reachEnd);
            if (!hitResult.isPresent() || !((distance = eyePosition.m_82554_((Vec3)hitResult.get())) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        return closestEntity;
    }
}

