/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrauctionsbid;

import eu.mrneznamy.mrauctionsbid.commands.AuctionsCommand;
import eu.mrneznamy.mrauctionsbid.managers.AuctionManager;
import eu.mrneznamy.mrauctionsbid.managers.BlacklistManager;
import eu.mrneznamy.mrauctionsbid.managers.ConfigManager;
import eu.mrneznamy.mrauctionsbid.managers.MessageManager;
import eu.mrneznamy.mrauctionsbid.utils.CheckUpdates;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class MrAuctionsBid
extends JavaPlugin
implements Listener {
    private ConfigManager configManager;
    private MessageManager messageManager;
    private BlacklistManager blacklistManager;
    private AuctionManager auctionManager;
    private Economy economy;

    public void onEnable() {
        if (!this.setupEconomy()) {
            this.getLogger().severe("Vault not found! Plugin disabled.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.configManager = new ConfigManager(this);
        this.messageManager = new MessageManager(this);
        this.blacklistManager = new BlacklistManager(this);
        this.auctionManager = new AuctionManager(this, this.configManager, this.messageManager, this.blacklistManager, this.economy);
        AuctionsCommand auctionsCommand = new AuctionsCommand(this, this.auctionManager, this.blacklistManager, this.configManager, this.messageManager);
        this.getCommand("auctions").setExecutor((CommandExecutor)auctionsCommand);
        this.getCommand("auctions").setTabCompleter((TabCompleter)auctionsCommand);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        CheckUpdates updater = new CheckUpdates();
        updater.EnableMessage();
        updater.checkForUpdates();
    }

    public void onDisable() {
        if (this.auctionManager != null) {
            this.auctionManager.forceEndAuction();
        }
        this.getLogger().info("MrAuctionsBid has been disabled!");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.auctionManager != null) {
            this.auctionManager.addPlayerToBossBar(player);
        }
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public BlacklistManager getBlacklistManager() {
        return this.blacklistManager;
    }

    public AuctionManager getAuctionManager() {
        return this.auctionManager;
    }

    public Economy getEconomy() {
        return this.economy;
    }
}

