/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrauctionsbid.commands;

import eu.mrneznamy.mrauctionsbid.MrAuctionsBid;
import eu.mrneznamy.mrauctionsbid.managers.AuctionManager;
import eu.mrneznamy.mrauctionsbid.managers.BlacklistManager;
import eu.mrneznamy.mrauctionsbid.managers.ConfigManager;
import eu.mrneznamy.mrauctionsbid.managers.MessageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AuctionsCommand
implements CommandExecutor,
TabCompleter {
    private final MrAuctionsBid plugin;
    private final AuctionManager auctionManager;
    private final BlacklistManager blacklistManager;
    private final ConfigManager configManager;
    private final MessageManager messageManager;

    public AuctionsCommand(MrAuctionsBid plugin, AuctionManager auctionManager, BlacklistManager blacklistManager, ConfigManager configManager, MessageManager messageManager) {
        this.plugin = plugin;
        this.auctionManager = auctionManager;
        this.blacklistManager = blacklistManager;
        this.configManager = configManager;
        this.messageManager = messageManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelpMessage(player);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "create": {
                this.handleCreateCommand(player, args);
                break;
            }
            case "bid": {
                this.handleBidCommand(player, args);
                break;
            }
            case "reload": {
                this.handleReloadCommand(player);
                break;
            }
            case "blacklist": {
                this.handleBlacklistCommand(player, args);
                break;
            }
            default: {
                this.sendHelpMessage(player);
            }
        }
        return true;
    }

    private void handleCreateCommand(Player player, String[] args) {
        double price;
        if (!player.hasPermission("mrauctionsbid.command.create")) {
            this.messageManager.sendMessage(player, "NoPermission");
            return;
        }
        if (args.length != 2) {
            player.sendMessage(this.messageManager.getUsageMessage("Create"));
            return;
        }
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null || itemInHand.getType() == Material.AIR) {
            this.messageManager.sendMessage(player, "NoItemInHand");
            return;
        }
        try {
            price = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            this.messageManager.sendMessage(player, "InvalidAmount");
            return;
        }
        if (price <= 0.0) {
            this.messageManager.sendMessage(player, "InvalidAmount");
            return;
        }
        this.auctionManager.createAuction(player, itemInHand, price);
    }

    private void handleBidCommand(Player player, String[] args) {
        double amount;
        if (!player.hasPermission("mrauctionsbid.command.bid")) {
            this.messageManager.sendMessage(player, "NoPermission");
            return;
        }
        if (args.length != 2) {
            player.sendMessage(this.messageManager.getUsageMessage("Bid"));
            return;
        }
        try {
            amount = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            this.messageManager.sendMessage(player, "InvalidAmount");
            return;
        }
        if (amount <= 0.0) {
            this.messageManager.sendMessage(player, "InvalidAmount");
            return;
        }
        this.auctionManager.placeBid(player, amount);
    }

    private void handleReloadCommand(Player player) {
        if (!player.hasPermission("mrauctionsbid.command.reload")) {
            this.messageManager.sendMessage(player, "NoPermission");
            return;
        }
        this.auctionManager.forceEndAuction();
        this.configManager.reloadConfig();
        this.messageManager.reloadMessages();
        this.blacklistManager.loadBlacklist();
        this.messageManager.sendMessage(player, "ConfigReloaded");
    }

    private void handleBlacklistCommand(Player player, String[] args) {
        if (!player.hasPermission("mrauctionsbid.command.blacklist")) {
            this.messageManager.sendMessage(player, "NoPermission");
            return;
        }
        if (args.length < 3) {
            player.sendMessage(this.messageManager.getUsageMessage("Blacklist"));
            return;
        }
        String action = args[1].toLowerCase();
        String itemName = args[2].toUpperCase();
        switch (action) {
            case "add": {
                this.handleBlacklistAdd(player, itemName);
                break;
            }
            case "remove": {
                this.handleBlacklistRemove(player, itemName);
                break;
            }
            default: {
                player.sendMessage(this.messageManager.getUsageMessage("Blacklist"));
            }
        }
    }

    private void handleBlacklistAdd(Player player, String itemName) {
        if (itemName.equals("HAND")) {
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            if (itemInHand == null || itemInHand.getType() == Material.AIR) {
                this.messageManager.sendMessage(player, "NoItemInHand");
                return;
            }
            if (this.blacklistManager.addToBlacklist(itemInHand)) {
                String displayName = this.blacklistManager.getItemDisplayName(itemInHand);
                this.messageManager.sendMessage(player, "ItemAdded", "%item%", displayName);
            } else {
                String displayName = this.blacklistManager.getItemDisplayName(itemInHand);
                this.messageManager.sendMessage(player, "ItemAlreadyInBlacklist", "%item%", displayName);
            }
        } else if (this.blacklistManager.addToBlacklist(itemName)) {
            this.messageManager.sendMessage(player, "ItemAdded", "%item%", itemName);
        } else {
            this.messageManager.sendMessage(player, "ItemAlreadyInBlacklist", "%item%", itemName);
        }
    }

    private void handleBlacklistRemove(Player player, String itemName) {
        if (this.blacklistManager.removeFromBlacklist(itemName)) {
            this.messageManager.sendMessage(player, "ItemRemoved", "%item%", itemName);
        } else {
            this.messageManager.sendMessage(player, "ItemNotInBlacklist", "%item%", itemName);
        }
    }

    private void sendHelpMessage(Player player) {
        player.sendMessage(this.messageManager.getPrefix() + "&6=== MrAuctionsBid Commands ===");
        player.sendMessage(this.messageManager.getPrefix() + "&e/auctions create <price> &7- Create an auction");
        player.sendMessage(this.messageManager.getPrefix() + "&e/auctions bid <price> &7- Bid on an auction");
        player.sendMessage(this.messageManager.getPrefix() + "&e/auctions reload &7- Reload configuration");
        player.sendMessage(this.messageManager.getPrefix() + "&e/auctions blacklist add <item/HAND> &7- Add item to blacklist");
        player.sendMessage(this.messageManager.getPrefix() + "&e/auctions blacklist remove <item> &7- Remove item from blacklist");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subcommands = Arrays.asList("create", "bid", "reload", "blacklist");
            return subcommands.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("blacklist")) {
            List<String> actions = Arrays.asList("add", "remove");
            return actions.stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("blacklist")) {
            if (args[1].equalsIgnoreCase("add")) {
                ArrayList<String> materials = new ArrayList<String>();
                materials.add("HAND");
                for (Material material : Material.values()) {
                    if (!material.isItem()) continue;
                    materials.add(material.name());
                }
                return materials.stream().filter(s -> s.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
            }
            if (args[1].equalsIgnoreCase("remove")) {
                return this.blacklistManager.getBlacklistedItems().stream().filter(s -> s.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
            }
        }
        return completions;
    }
}

