/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrauctionsbid.managers;

import eu.mrneznamy.mrauctionsbid.MrAuctionsBid;
import eu.mrneznamy.mrauctionsbid.managers.BlacklistManager;
import eu.mrneznamy.mrauctionsbid.managers.ConfigManager;
import eu.mrneznamy.mrauctionsbid.managers.MessageManager;
import eu.mrneznamy.mrauctionsbid.utils.ColorSystem;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AuctionManager {
    private final MrAuctionsBid plugin;
    private final ConfigManager configManager;
    private final MessageManager messageManager;
    private final BlacklistManager blacklistManager;
    private final Economy economy;
    private boolean auctionActive = false;
    private boolean auctionStarting = false;
    private boolean auctionEnding = false;
    private boolean endingBossBarActive = false;
    private Player auctioneer;
    private ItemStack auctionItem;
    private double currentBid;
    private double minimumBid;
    private Player highestBidder;
    private Map<Player, Double> bidHistory;
    private BossBar bossBar;
    private BukkitTask auctionTask;
    private int countdown;
    private int maxCountdown;
    private final DecimalFormat df = new DecimalFormat("#.##");

    public AuctionManager(MrAuctionsBid plugin, ConfigManager configManager, MessageManager messageManager, BlacklistManager blacklistManager, Economy economy) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.messageManager = messageManager;
        this.blacklistManager = blacklistManager;
        this.economy = economy;
        this.bidHistory = new HashMap<Player, Double>();
        this.auctionActive = false;
        this.auctionStarting = false;
        this.auctionEnding = false;
        this.endingBossBarActive = false;
    }

    public boolean createAuction(Player player, ItemStack item, double minimumPrice) {
        if (this.auctionActive || this.auctionStarting || this.auctionEnding || this.endingBossBarActive) {
            this.messageManager.sendMessage(player, "AuctionActive");
            return false;
        }
        if (this.blacklistManager.isBlacklisted(item)) {
            this.messageManager.sendMessage(player, "ItemBlacklisted");
            return false;
        }
        if (minimumPrice < this.configManager.getMinimumPriceAuctionStart()) {
            this.messageManager.sendMessage(player, "BidTooLow", "%amount%", this.df.format(this.configManager.getMinimumPriceAuctionStart()));
            return false;
        }
        this.auctioneer = player;
        this.auctionItem = item.clone();
        this.minimumBid = minimumPrice;
        this.currentBid = minimumPrice;
        this.highestBidder = null;
        this.bidHistory.clear();
        player.getInventory().removeItem(new ItemStack[]{item});
        this.startAuctionCountdown();
        String itemName = this.blacklistManager.getItemDisplayName(item);
        this.messageManager.sendMessage(player, "AuctionCreated", "%item%", itemName, "%amount%", this.df.format(minimumPrice));
        return true;
    }

    private void startAuctionCountdown() {
        this.auctionStarting = true;
        this.maxCountdown = this.countdown = this.configManager.getStartAuctionTimer();
        this.createBossBar(this.configManager.getStartAuctionText(), this.configManager.getStartAuctionBarColor(), this.configManager.getStartAuctionBarStyle());
        this.updateBossBarProgress();
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.playSound(player.getLocation(), this.configManager.getStartAuctionSound(), 1.0f, 1.0f);
        }
        this.auctionTask = new BukkitRunnable(){

            public void run() {
                if (AuctionManager.this.countdown <= 0) {
                    AuctionManager.this.startAuction();
                    this.cancel();
                    return;
                }
                AuctionManager.this.updateBossBar(AuctionManager.this.configManager.getStartAuctionText().replace("%countdown%", String.valueOf(AuctionManager.this.countdown)));
                AuctionManager.this.updateBossBarProgress();
                AuctionManager.this.countdown--;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void startAuction() {
        this.auctionStarting = false;
        this.auctionActive = true;
        this.maxCountdown = this.countdown = this.configManager.getAuctionTimer();
        final String itemName = this.blacklistManager.getItemDisplayName(this.auctionItem);
        String playerName = this.highestBidder != null ? this.highestBidder.getName() : this.configManager.getNoWinnerMessage();
        String initialBossBarText = this.configManager.getAuctionText().replace("%item%", itemName).replace("%price%", this.df.format(this.currentBid + 1.0)).replace("%player%", playerName).replace("%countdown%", String.valueOf(this.countdown));
        this.createBossBar(initialBossBarText, this.configManager.getAuctionBarColor(), this.configManager.getAuctionBarStyle());
        this.updateBossBarProgress();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.messageManager.sendMessage(player, "AuctionStarting");
        }
        this.auctionTask = new BukkitRunnable(){

            public void run() {
                if (AuctionManager.this.countdown <= 0) {
                    AuctionManager.this.endAuction();
                    this.cancel();
                    return;
                }
                if (AuctionManager.this.countdown == 5 && !AuctionManager.this.auctionEnding) {
                    AuctionManager.this.auctionEnding = true;
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        AuctionManager.this.messageManager.sendMessage(player, "AuctionEnding");
                    }
                }
                String playerName = AuctionManager.this.highestBidder != null ? AuctionManager.this.highestBidder.getName() : AuctionManager.this.configManager.getNoWinnerMessage();
                String bossBarText = AuctionManager.this.configManager.getAuctionText().replace("%item%", itemName).replace("%price%", AuctionManager.this.df.format(AuctionManager.this.currentBid + 1.0)).replace("%player%", playerName).replace("%countdown%", String.valueOf(AuctionManager.this.countdown));
                AuctionManager.this.updateBossBar(bossBarText);
                AuctionManager.this.updateBossBarProgress();
                AuctionManager.this.countdown--;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public boolean placeBid(Player player, double amount) {
        if (!this.auctionActive || this.auctionStarting || this.auctionEnding) {
            if (!this.auctionActive) {
                this.messageManager.sendMessage(player, "NoAuction");
            } else {
                this.messageManager.sendMessage(player, "AuctionEnding");
            }
            return false;
        }
        if (player.equals((Object)this.auctioneer)) {
            this.messageManager.sendMessage(player, "AuctioneerCannotBid");
            return false;
        }
        if (player.equals((Object)this.highestBidder)) {
            this.messageManager.sendMessage(player, "AlreadyHighestBidder");
            return false;
        }
        if (amount <= this.currentBid) {
            this.messageManager.sendMessage(player, "BidTooLow", "%amount%", this.df.format(this.currentBid + 1.0));
            return false;
        }
        if (!this.economy.has((OfflinePlayer)player, amount)) {
            this.messageManager.sendMessage(player, "NotEnoughMoney");
            return false;
        }
        if (this.highestBidder != null) {
            this.economy.depositPlayer((OfflinePlayer)this.highestBidder, this.currentBid);
            this.messageManager.sendMessage(this.highestBidder, "AuctionLost");
        }
        this.economy.withdrawPlayer((OfflinePlayer)player, amount);
        this.highestBidder = player;
        this.currentBid = amount;
        this.bidHistory.put(player, amount);
        this.messageManager.sendMessage(this.auctioneer, "BidPlaced", "%amount%", this.df.format(amount));
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            onlinePlayer.playSound(onlinePlayer.getLocation(), this.configManager.getBidToAuctionSound(), 1.0f, 1.0f);
            if (onlinePlayer.equals((Object)player)) continue;
            this.messageManager.sendMessage(onlinePlayer, "BidAnnouncement", "%player%", player.getName(), "%amount%", this.df.format(amount));
        }
        int expandTime = this.configManager.getExpandTimerWhenBidding();
        this.countdown += expandTime;
        if (this.countdown > this.maxCountdown) {
            this.maxCountdown = this.countdown;
        }
        return true;
    }

    private void endAuction() {
        String endMessage;
        this.auctionActive = false;
        this.auctionEnding = false;
        if (this.highestBidder != null) {
            if (this.highestBidder.getInventory().firstEmpty() != -1) {
                this.highestBidder.getInventory().addItem(new ItemStack[]{this.auctionItem});
            } else {
                this.highestBidder.getWorld().dropItemNaturally(this.highestBidder.getLocation(), this.auctionItem);
            }
            this.economy.depositPlayer((OfflinePlayer)this.auctioneer, this.currentBid);
            String itemName = this.blacklistManager.getItemDisplayName(this.auctionItem);
            this.messageManager.sendMessage(this.highestBidder, "AuctionWon", "%item%", itemName, "%amount%", this.df.format(this.currentBid));
            endMessage = this.configManager.getEndAuctionText().replace("%player%", this.highestBidder.getName()).replace("%price%", this.df.format(this.currentBid));
        } else {
            if (this.auctioneer.getInventory().firstEmpty() != -1) {
                this.auctioneer.getInventory().addItem(new ItemStack[]{this.auctionItem});
            } else {
                this.auctioneer.getWorld().dropItemNaturally(this.auctioneer.getLocation(), this.auctionItem);
            }
            endMessage = this.configManager.getEndAuctionText().replace("%player%", this.configManager.getNoWinnerMessage()).replace("%price%", "0");
        }
        this.createBossBar(endMessage, this.configManager.getEndAuctionBarColor(), this.configManager.getEndAuctionBarStyle());
        this.endingBossBarActive = true;
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.playSound(player.getLocation(), this.configManager.getEndAuctionSound(), 1.0f, 1.0f);
        }
        new BukkitRunnable(){

            public void run() {
                if (AuctionManager.this.bossBar != null) {
                    AuctionManager.this.bossBar.removeAll();
                    AuctionManager.this.bossBar = null;
                }
                AuctionManager.this.endingBossBarActive = false;
                AuctionManager.this.resetAuction();
            }
        }.runTaskLater((Plugin)this.plugin, (long)this.configManager.getEndAuctionTimer() * 20L);
    }

    private void resetAuction() {
        this.auctionActive = false;
        this.auctionStarting = false;
        this.auctionEnding = false;
        this.endingBossBarActive = false;
        this.auctioneer = null;
        this.auctionItem = null;
        this.currentBid = 0.0;
        this.minimumBid = 0.0;
        this.highestBidder = null;
        this.bidHistory.clear();
        if (this.auctionTask != null) {
            this.auctionTask.cancel();
            this.auctionTask = null;
        }
    }

    private void createBossBar(String title, BarColor color, BarStyle style) {
        if (this.bossBar != null) {
            this.bossBar.removeAll();
        }
        this.bossBar = Bukkit.createBossBar((String)ColorSystem.colorize(title), (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.bossBar.addPlayer(player);
        }
        this.bossBar.setVisible(true);
    }

    private void updateBossBar(String title) {
        if (this.bossBar != null) {
            this.bossBar.setTitle(ColorSystem.colorize(title));
        }
    }

    private void updateBossBarProgress() {
        if (this.bossBar != null && this.maxCountdown > 0) {
            double progress = (double)this.countdown / (double)this.maxCountdown;
            progress = Math.max(0.0, Math.min(1.0, progress));
            this.bossBar.setProgress(progress);
        }
    }

    public void addPlayerToBossBar(Player player) {
        if (this.bossBar != null) {
            this.bossBar.addPlayer(player);
        }
    }

    public boolean isAuctionActive() {
        return this.auctionActive;
    }

    public boolean isAuctionStarting() {
        return this.auctionStarting;
    }

    public boolean isAuctionEnding() {
        return this.auctionEnding;
    }

    public void forceEndAuction() {
        if (this.auctionActive || this.auctionStarting || this.auctionEnding) {
            if (this.auctionTask != null) {
                this.auctionTask.cancel();
            }
            this.endAuction();
        }
    }
}

