/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrauctionsbid.managers;

import eu.mrneznamy.mrauctionsbid.MrAuctionsBid;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BlacklistManager {
    private final MrAuctionsBid plugin;
    private FileConfiguration blacklistConfig;
    private File blacklistFile;

    public BlacklistManager(MrAuctionsBid plugin) {
        this.plugin = plugin;
        this.loadBlacklist();
    }

    public void loadBlacklist() {
        this.blacklistFile = new File(this.plugin.getDataFolder(), "blacklist.yml");
        if (!this.blacklistFile.exists()) {
            try {
                this.plugin.getDataFolder().mkdirs();
                this.blacklistFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create blacklist.yml file: " + e.getMessage());
            }
        }
        this.blacklistConfig = YamlConfiguration.loadConfiguration((File)this.blacklistFile);
        if (!this.blacklistConfig.contains("blacklisted-items")) {
            this.blacklistConfig.set("blacklisted-items", new ArrayList());
            this.saveBlacklist();
        }
    }

    public void saveBlacklist() {
        try {
            this.blacklistConfig.save(this.blacklistFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save blacklist.yml file: " + e.getMessage());
        }
    }

    public boolean isBlacklisted(ItemStack item) {
        String customItem;
        String materialName;
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        List blacklistedItems = this.blacklistConfig.getStringList("blacklisted-items");
        if (blacklistedItems.contains(materialName = item.getType().name())) {
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        return meta != null && meta.hasCustomModelData() && blacklistedItems.contains(customItem = materialName + ":" + meta.getCustomModelData());
    }

    public boolean addToBlacklist(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        String itemIdentifier = meta != null && meta.hasCustomModelData() ? item.getType().name() + ":" + meta.getCustomModelData() : item.getType().name();
        List blacklistedItems = this.blacklistConfig.getStringList("blacklisted-items");
        if (blacklistedItems.contains(itemIdentifier)) {
            return false;
        }
        blacklistedItems.add(itemIdentifier);
        this.blacklistConfig.set("blacklisted-items", (Object)blacklistedItems);
        this.saveBlacklist();
        return true;
    }

    public boolean addToBlacklist(String materialName) {
        try {
            Material material = Material.valueOf((String)materialName.toUpperCase());
            List blacklistedItems = this.blacklistConfig.getStringList("blacklisted-items");
            if (blacklistedItems.contains(materialName.toUpperCase())) {
                return false;
            }
            blacklistedItems.add(materialName.toUpperCase());
            this.blacklistConfig.set("blacklisted-items", (Object)blacklistedItems);
            this.saveBlacklist();
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean removeFromBlacklist(String itemIdentifier) {
        List blacklistedItems = this.blacklistConfig.getStringList("blacklisted-items");
        if (!blacklistedItems.contains(itemIdentifier.toUpperCase())) {
            return false;
        }
        blacklistedItems.remove(itemIdentifier.toUpperCase());
        this.blacklistConfig.set("blacklisted-items", (Object)blacklistedItems);
        this.saveBlacklist();
        return true;
    }

    public List<String> getBlacklistedItems() {
        return this.blacklistConfig.getStringList("blacklisted-items");
    }

    public String getItemDisplayName(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return "AIR";
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            return meta.getDisplayName();
        }
        if (meta != null && meta.hasCustomModelData()) {
            return item.getType().name() + ":" + meta.getCustomModelData();
        }
        return item.getType().name();
    }
}

