/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrauctionsbid.managers;

import eu.mrneznamy.mrauctionsbid.MrAuctionsBid;
import java.io.File;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final MrAuctionsBid plugin;
    private FileConfiguration config;
    private FileConfiguration messagesConfig;

    public ConfigManager(MrAuctionsBid plugin) {
        this.plugin = plugin;
        this.loadConfig();
        this.loadMessages();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfig() {
        this.loadConfig();
        this.loadMessages();
    }

    private void loadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (messagesFile.exists()) {
            this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
        }
    }

    public String getNoWinnerMessage() {
        if (this.messagesConfig != null) {
            return this.messagesConfig.getString("MrAuctionsBid.Messages.NoWinner", "None");
        }
        return "None";
    }

    public String getEconomyType() {
        return this.config.getString("MrAuctionsBid.EconomyType", "Vault");
    }

    public double getMinimumPriceAuctionStart() {
        return this.config.getDouble("MrAuctionsBid.MinimumPriceAuctionStart", 1000.0);
    }

    public int getExpandTimerWhenBidding() {
        return this.config.getInt("MrAuctionsBid.ExpandTimerWhenBidding", 5);
    }

    public String getStartAuctionText() {
        return this.config.getString("MrAuctionsBid.BossBars.StartAuction.Text", "&cAuction starting in %countdown% seconds");
    }

    public BarColor getStartAuctionBarColor() {
        String color = this.config.getString("MrAuctionsBid.BossBars.StartAuction.BarColor", "GREEN");
        try {
            return BarColor.valueOf((String)color.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return BarColor.GREEN;
        }
    }

    public int getStartAuctionTimer() {
        return this.config.getInt("MrAuctionsBid.BossBars.StartAuction.Timer", 3);
    }

    public BarStyle getStartAuctionBarStyle() {
        String style = this.config.getString("MrAuctionsBid.BossBars.StartAuction.BarStyle", "SOLID");
        try {
            switch (style.toUpperCase()) {
                case "PROGRESS": {
                    return BarStyle.SOLID;
                }
                case "NOTCHED_6": {
                    return BarStyle.SEGMENTED_6;
                }
                case "NOTCHED_10": {
                    return BarStyle.SEGMENTED_10;
                }
                case "NOTCHED_12": {
                    return BarStyle.SEGMENTED_12;
                }
                case "NOTCHED_20": {
                    return BarStyle.SEGMENTED_20;
                }
            }
            return BarStyle.valueOf((String)style.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return BarStyle.SOLID;
        }
    }

    public String getAuctionText() {
        return this.config.getString("MrAuctionsBid.BossBars.Auction.Text", "%item% &8 | Auction end in %countdown% seconds &8(&a/auction bid&8)");
    }

    public BarColor getAuctionBarColor() {
        String color = this.config.getString("MrAuctionsBid.BossBars.Auction.BarColor", "YELLOW");
        try {
            return BarColor.valueOf((String)color.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return BarColor.YELLOW;
        }
    }

    public int getAuctionTimer() {
        return this.config.getInt("MrAuctionsBid.BossBars.Auction.Timer", 15);
    }

    public BarStyle getAuctionBarStyle() {
        String style = this.config.getString("MrAuctionsBid.BossBars.Auction.BarStyle", "SOLID");
        try {
            switch (style.toUpperCase()) {
                case "PROGRESS": {
                    return BarStyle.SOLID;
                }
                case "NOTCHED_6": {
                    return BarStyle.SEGMENTED_6;
                }
                case "NOTCHED_10": {
                    return BarStyle.SEGMENTED_10;
                }
                case "NOTCHED_12": {
                    return BarStyle.SEGMENTED_12;
                }
                case "NOTCHED_20": {
                    return BarStyle.SEGMENTED_20;
                }
            }
            return BarStyle.valueOf((String)style.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return BarStyle.SOLID;
        }
    }

    public String getEndAuctionText() {
        return this.config.getString("MrAuctionsBid.BossBars.EndAuction.Text", "Auction Ended, winner is %player% buyed for %price%");
    }

    public BarColor getEndAuctionBarColor() {
        String color = this.config.getString("MrAuctionsBid.BossBars.EndAuction.BarColor", "RED");
        try {
            return BarColor.valueOf((String)color.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return BarColor.RED;
        }
    }

    public int getEndAuctionTimer() {
        return this.config.getInt("MrAuctionsBid.BossBars.EndAuction.Timer", 3);
    }

    public BarStyle getEndAuctionBarStyle() {
        String style = this.config.getString("MrAuctionsBid.BossBars.EndAuction.BarStyle", "SOLID");
        try {
            switch (style.toUpperCase()) {
                case "PROGRESS": {
                    return BarStyle.SOLID;
                }
                case "NOTCHED_6": {
                    return BarStyle.SEGMENTED_6;
                }
                case "NOTCHED_10": {
                    return BarStyle.SEGMENTED_10;
                }
                case "NOTCHED_12": {
                    return BarStyle.SEGMENTED_12;
                }
                case "NOTCHED_20": {
                    return BarStyle.SEGMENTED_20;
                }
            }
            return BarStyle.valueOf((String)style.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return BarStyle.SOLID;
        }
    }

    public Sound getStartAuctionSound() {
        String soundName = this.config.getString("MrAuctionsBid.Sounds.StartAuction", "block.amethyst_block.place");
        try {
            return Sound.valueOf((String)soundName.toUpperCase().replace(".", "_"));
        }
        catch (IllegalArgumentException e) {
            return Sound.BLOCK_AMETHYST_BLOCK_PLACE;
        }
    }

    public Sound getBidToAuctionSound() {
        String soundName = this.config.getString("MrAuctionsBid.Sounds.BidtoAuction", "block.amethyst_block.step");
        try {
            return Sound.valueOf((String)soundName.toUpperCase().replace(".", "_"));
        }
        catch (IllegalArgumentException e) {
            return Sound.BLOCK_AMETHYST_BLOCK_STEP;
        }
    }

    public Sound getEndAuctionSound() {
        String soundName = this.config.getString("MrAuctionsBid.Sounds.EndAuction", "block.amethyst_cluster.break");
        try {
            return Sound.valueOf((String)soundName.toUpperCase().replace(".", "_"));
        }
        catch (IllegalArgumentException e) {
            return Sound.BLOCK_AMETHYST_CLUSTER_BREAK;
        }
    }
}

