/*
 * Decompiled with CFR 0.152.
 */
package eu.mrneznamy.mrauctionsbid.managers;

import eu.mrneznamy.mrauctionsbid.MrAuctionsBid;
import eu.mrneznamy.mrauctionsbid.utils.ColorSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessageManager {
    private final MrAuctionsBid plugin;
    private FileConfiguration messagesConfig;
    private File messagesFile;

    public MessageManager(MrAuctionsBid plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    public void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            try {
                this.plugin.getDataFolder().mkdirs();
                InputStream inputStream = this.plugin.getResource("messages.yml");
                if (inputStream != null) {
                    Files.copy(inputStream, this.messagesFile.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create messages.yml file: " + e.getMessage());
            }
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public void reloadMessages() {
        this.loadMessages();
    }

    public String getPrefix() {
        String prefix = this.messagesConfig.getString("MrAuctionsBid.Prefix", "&8[&6MrAuctionsBid&8] ");
        return ColorSystem.colorize(prefix);
    }

    public String getMessage(String key) {
        String message = this.messagesConfig.getString("MrAuctionsBid.Messages." + key, "&cMessage not found: " + key);
        return ColorSystem.colorize(this.getPrefix() + message);
    }

    public String getMessage(String key, String ... placeholders) {
        String message = this.getMessage(key);
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            message = message.replace(placeholders[i], placeholders[i + 1]);
        }
        return message;
    }

    public void sendMessage(Player player, String key) {
        player.sendMessage(this.getMessage(key));
    }

    public void sendMessage(Player player, String key, String ... placeholders) {
        player.sendMessage(this.getMessage(key, placeholders));
    }

    public String getUsageMessage(String command) {
        String message = this.messagesConfig.getString("MrAuctionsBid.Messages.Usage." + command, "&cUsage not found for: " + command);
        return ColorSystem.colorize(this.getPrefix() + message);
    }
}

