/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.network;

import com.blorb.morerelics.network.SilkCounterPayload;
import com.blorb.morerelics.network.SoarVelocityPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"morerelics", (String)"messages")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
    private static int packetId = 0;

    private static int id() {
        return packetId++;
    }

    public static void register() {
        INSTANCE.messageBuilder(SilkCounterPayload.class, PacketHandler.id(), NetworkDirection.PLAY_TO_CLIENT).encoder(SilkCounterPayload::encode).decoder(SilkCounterPayload::decode).consumerMainThread(SilkCounterPayload::handle).add();
        INSTANCE.messageBuilder(SoarVelocityPayload.class, PacketHandler.id(), NetworkDirection.PLAY_TO_CLIENT).encoder(SoarVelocityPayload::encode).decoder(SoarVelocityPayload::decode).consumerMainThread(SoarVelocityPayload::handle).add();
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static void sendToPlayer(Object msg, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), msg);
    }

    public static void sendToAllClients(Object msg) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), msg);
    }
}

