/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.network;

import com.blorb.morerelics.MoreRelicUtils;
import com.blorb.morerelics.relics.WeaversSpool;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;

public class SilkCounterPayload {
    public static final ResourceLocation TYPE = ResourceLocation.fromNamespaceAndPath((String)"morerelics", (String)"silk_counter");
    private final int silkCounter;

    public SilkCounterPayload(int silkCounter) {
        this.silkCounter = silkCounter;
    }

    public static void encode(SilkCounterPayload payload, FriendlyByteBuf buffer) {
        buffer.writeInt(payload.silkCounter);
    }

    public static SilkCounterPayload decode(FriendlyByteBuf buffer) {
        return new SilkCounterPayload(buffer.readInt());
    }

    public static void handle(SilkCounterPayload payload, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> MoreRelicUtils.actuallyGetEquippedRelics((LivingEntity)context.getSender()).forEach(stack -> {
                Item patt1567$temp = stack.m_41720_();
                if (patt1567$temp instanceof WeaversSpool) {
                    WeaversSpool item = (WeaversSpool)patt1567$temp;
                    return;
                }
                stack.m_41784_().m_128405_("current_silk", payload.silkCounter);
            }));
        }
        context.setPacketHandled(true);
    }
}

