/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics;

import com.blorb.morerelics.Config;
import com.blorb.morerelics.dataComponents.AttachmentHandler;
import com.blorb.morerelics.dataComponents.DataComponentHandler;
import com.blorb.morerelics.effects.Corrosion;
import com.blorb.morerelics.effects.Cyberpsychosis;
import com.blorb.morerelics.effects.Overload;
import com.blorb.morerelics.effects.Static;
import com.blorb.morerelics.effects.Vulnerability;
import com.blorb.morerelics.network.SilkCounterPayload;
import com.blorb.morerelics.network.SilkCounterPayloadHandler;
import com.blorb.morerelics.network.SoarVelocityPayload;
import com.blorb.morerelics.network.SoarVelocityPayloadHandler;
import com.blorb.morerelics.particles.VaryingAnimationParticle;
import com.blorb.morerelics.relics.AxolotlCream;
import com.blorb.morerelics.relics.BioJoint;
import com.blorb.morerelics.relics.BionicEye;
import com.blorb.morerelics.relics.CrownOfTheLegend;
import com.blorb.morerelics.relics.DepletedSpool;
import com.blorb.morerelics.relics.EjectButton;
import com.blorb.morerelics.relics.GutsOrb;
import com.blorb.morerelics.relics.KingCrimson;
import com.blorb.morerelics.relics.MadeInHeaven;
import com.blorb.morerelics.relics.MassGauntlet;
import com.blorb.morerelics.relics.MoodWorm;
import com.blorb.morerelics.relics.OpalNecklace;
import com.blorb.morerelics.relics.SentientRust;
import com.blorb.morerelics.relics.ShieldWeaveCape;
import com.blorb.morerelics.relics.SlumberingAmulet;
import com.blorb.morerelics.relics.ThermoseismicHeart;
import com.blorb.morerelics.relics.TyrantMask;
import com.blorb.morerelics.relics.WeaversSpool;
import com.blorb.morerelics.relics.WhimsOfFate;
import com.blorb.morerelics.relics.WhisperingAmulet;
import com.mojang.logging.LogUtils;
import java.util.function.Supplier;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="morerelics")
public class MoreRelics {
    public static final String MODID = "morerelics";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"morerelics");
    public static final DeferredItem<Item> GUTS_ORB = ITEMS.registerItem("guts_orb", GutsOrb::new);
    public static final DeferredItem<Item> SLUMBERING_AMULET = ITEMS.registerItem("slumbering_amulet", SlumberingAmulet::new);
    public static final DeferredItem<Item> WHISPERING_AMULET = ITEMS.registerItem("whispering_amulet", WhisperingAmulet::new);
    public static final DeferredItem<Item> MADE_IN_HEAVEN = ITEMS.registerItem("made_in_heaven", MadeInHeaven::new);
    public static final DeferredItem<Item> MASS_GAUNTLET = ITEMS.registerItem("mass_gauntlet", MassGauntlet::new);
    public static final DeferredItem<Item> EJECT_BUTTON = ITEMS.registerItem("eject_button", EjectButton::new);
    public static final DeferredItem<Item> SHIELDWEAVE_CAPE = ITEMS.registerItem("shieldweave_cape", ShieldWeaveCape::new);
    public static final DeferredItem<Item> AXOLOTL_CREAM = ITEMS.registerItem("axolotl_cream", AxolotlCream::new);
    public static final DeferredItem<Item> SENTIENT_RUST = ITEMS.registerItem("sentient_rust", SentientRust::new);
    public static final DeferredItem<Item> OPAL_NECKLACE = ITEMS.registerItem("opal_necklace", OpalNecklace::new);
    public static final DeferredItem<Item> TYRANT_MASK = ITEMS.registerItem("tyrant_mask", TyrantMask::new);
    public static final DeferredItem<Item> KING_CRIMSON = ITEMS.registerItem("king_crimson", KingCrimson::new);
    public static final DeferredItem<Item> CROWN_OF_THE_LEGEND = ITEMS.registerItem("crown_of_the_legend", CrownOfTheLegend::new);
    public static final DeferredItem<Item> BIONIC_EYE = ITEMS.registerItem("bionic_eye", BionicEye::new);
    public static final DeferredItem<Item> THERMOSEISMIC_HEART = ITEMS.registerItem("thermoseismic_heart", ThermoseismicHeart::new);
    public static final DeferredItem<Item> BIOJOINT = ITEMS.registerItem("biojoint", BioJoint::new);
    public static final DeferredItem<Item> WHIMS_OF_FATE = ITEMS.registerItem("whims_of_fate", WhimsOfFate::new);
    public static final DeferredItem<Item> DEPLETED_SPOOL = ITEMS.registerItem("depleted_spool", DepletedSpool::new);
    public static final DeferredItem<Item> WEAVERS_SPOOL = ITEMS.registerItem("weavers_spool", WeaversSpool::new);
    public static final DeferredItem<Item> MOODWORM = ITEMS.registerItem("moodworm", MoodWorm::new);
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"morerelics");
    public static final Holder<MobEffect> CORROSION = EFFECTS.register("corrosion", () -> new Corrosion().addAttributeModifier(Attributes.ARMOR, ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"armor_corrosion"), -0.05, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffect> STATIC = EFFECTS.register("static", Static::new);
    public static final Holder<MobEffect> VULNERABILITY = EFFECTS.register("vulnerability", Vulnerability::new);
    public static final Holder<MobEffect> CYBERPSYCHOSIS = EFFECTS.register("cyberpsychosis", () -> new Cyberpsychosis().addAttributeModifier(Attributes.ATTACK_DAMAGE, ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"attack_cyberpsychosis"), 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).addAttributeModifier(Attributes.MOVEMENT_SPEED, ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"speed_cyberpsychosis"), 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffect> OVERLOAD = EFFECTS.register("overload", () -> new Overload().addAttributeModifier(Attributes.MOVEMENT_SPEED, ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"speed_overload"), 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"morerelics");
    public static final Holder<SoundEvent> HEAL = SOUND_EVENTS.register("heal", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"heal")));
    public static final Holder<SoundEvent> JUDGEMENT = SOUND_EVENTS.register("judgement", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"judgement")));
    public static final Holder<SoundEvent> EXECUTE = SOUND_EVENTS.register("execute", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"execute")));
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((Registry)BuiltInRegistries.PARTICLE_TYPE, (String)"morerelics");
    public static final Supplier<SimpleParticleType> HOLY_FIRE = PARTICLES.register("holy_fire", () -> new SimpleParticleType(true));
    public static final Supplier<SimpleParticleType> GLITCHED_SOUL = PARTICLES.register("glitched_soul", () -> new SimpleParticleType(true));
    public static final ResourceKey<DamageType> CRIMSON_EXECUTE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"morerelics", (String)"crimson_execution"));

    public MoreRelics(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ITEMS.register(modEventBus);
        EFFECTS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        DataComponentHandler.REGISTRAR.register(modEventBus);
        AttachmentHandler.ATTACHMENT_TYPES.register(modEventBus);
        PARTICLES.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="morerelics")
    public static class CommonModEvents {
        @SubscribeEvent
        public static void onRegisterPayload(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            registrar.playBidirectional(SilkCounterPayload.TYPE, SilkCounterPayload.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(SilkCounterPayloadHandler.CLIENT_HANDLER, SilkCounterPayloadHandler.SERVER_HANDLER));
            registrar.playBidirectional(SoarVelocityPayload.TYPE, SoarVelocityPayload.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(SoarVelocityPayloadHandler.CLIENT_HANDLER, SoarVelocityPayloadHandler.SERVER_HANDLER));
        }
    }

    @EventBusSubscriber(modid="morerelics", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ClientModEvents.makeIntoWorm((Item)MOODWORM.get());
        }

        @SubscribeEvent
        public static void registerParticleFactory(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)HOLY_FIRE.get(), spriteSet -> new VaryingAnimationParticle.Provider(spriteSet, 10));
            event.registerSpriteSet((ParticleType)GLITCHED_SOUL.get(), spriteSet -> new VaryingAnimationParticle.Provider(spriteSet, 20));
        }

        public static void makeIntoWorm(Item item) {
            ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.parse((String)"mood"), (stack, a, b, c) -> DataComponentHandler.getAltIntegerCounter(stack).getCurrent());
        }
    }
}

