/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.dataComponents;

import com.blorb.morerelics.dataComponents.BoolHolder;
import com.blorb.morerelics.dataComponents.IntegerCounter;
import com.blorb.morerelics.dataComponents.LocationHolder;
import com.blorb.morerelics.dataComponents.StarCounter;
import com.blorb.morerelics.dataComponents.VectorDequeHolder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DataComponentHandler {
    public static final Codec<IntegerCounter> INTEGER_COUNTER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("current").forGetter(IntegerCounter::getCurrent)).apply((Applicative)instance, IntegerCounter::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, IntegerCounter> INTEGER_COUNTER_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, IntegerCounter::getCurrent, IntegerCounter::new);
    public static final Codec<VectorDequeHolder> VEC_DEQUE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("length").forGetter(VectorDequeHolder::getLength)).apply((Applicative)instance, VectorDequeHolder::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, VectorDequeHolder> VEC_DEQUE_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, VectorDequeHolder::getLength, VectorDequeHolder::new);
    public static final Codec<BoolHolder> BOOL_HOLDER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("bool").forGetter(BoolHolder::getBool)).apply((Applicative)instance, BoolHolder::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BoolHolder> BOOL_HOLDER_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, BoolHolder::getBool, BoolHolder::new);
    public static final Codec<StarCounter> STAR_COUNTER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("count").forGetter(StarCounter::getCount), (App)Codec.INT.fieldOf("timerCurrent").forGetter(StarCounter::getTimerCurrent)).apply((Applicative)instance, StarCounter::new));
    public static final StreamCodec<ByteBuf, StarCounter> STAR_COUNTER_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, StarCounter::getCount, (StreamCodec)ByteBufCodecs.INT, StarCounter::getTimerCurrent, StarCounter::new);
    public static final Codec<LocationHolder> LOCATION_HOLDER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("x").forGetter(LocationHolder::getX), (App)Codec.DOUBLE.fieldOf("y").forGetter(LocationHolder::getY), (App)Codec.DOUBLE.fieldOf("z").forGetter(LocationHolder::getZ)).apply((Applicative)instance, LocationHolder::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, LocationHolder> LOCATION_HOLDER_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, LocationHolder::getX, (StreamCodec)ByteBufCodecs.DOUBLE, LocationHolder::getY, (StreamCodec)ByteBufCodecs.DOUBLE, LocationHolder::getZ, LocationHolder::new);
    public static final DeferredRegister.DataComponents REGISTRAR = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"morerelics");
    public static final Supplier<DataComponentType<LocationHolder>> LOCATION_HOLDER = REGISTRAR.registerComponentType("location", builder -> builder.persistent(LOCATION_HOLDER_CODEC).networkSynchronized(LOCATION_HOLDER_STREAM_CODEC));
    public static final Supplier<DataComponentType<BoolHolder>> BOOL_HOLDER = REGISTRAR.registerComponentType("bool_holder", builder -> builder.persistent(BOOL_HOLDER_CODEC).networkSynchronized(BOOL_HOLDER_STREAM_CODEC));
    public static final Supplier<DataComponentType<VectorDequeHolder>> VECTOR_DEQUE_HOLDER = REGISTRAR.registerComponentType("vector_deque_holder", builder -> builder.persistent(VEC_DEQUE_CODEC).networkSynchronized(VEC_DEQUE_STREAM_CODEC));
    public static final Supplier<DataComponentType<IntegerCounter>> INT_COUNTER = REGISTRAR.registerComponentType("int_counter", builder -> builder.persistent(INTEGER_COUNTER_CODEC).networkSynchronized(INTEGER_COUNTER_STREAM_CODEC));
    public static final Supplier<DataComponentType<IntegerCounter>> ALT_INT_COUNTER = REGISTRAR.registerComponentType("alt_int_counter", builder -> builder.persistent(INTEGER_COUNTER_CODEC).networkSynchronized(INTEGER_COUNTER_STREAM_CODEC));
    public static final Supplier<DataComponentType<IntegerCounter>> ALT_ALT_INT_COUNTER = REGISTRAR.registerComponentType("alt_alt_int_counter", builder -> builder.persistent(INTEGER_COUNTER_CODEC).networkSynchronized(INTEGER_COUNTER_STREAM_CODEC));
    public static final Supplier<DataComponentType<LocationHolder>> THREE_INT_HOLDER = REGISTRAR.registerComponentType("three_int_holder", builder -> builder.persistent(LOCATION_HOLDER_CODEC).networkSynchronized(LOCATION_HOLDER_STREAM_CODEC));
    public static final Supplier<DataComponentType<StarCounter>> STAR_COUNTER = REGISTRAR.registerComponentType("star", builder -> builder.persistent(STAR_COUNTER_CODEC).networkSynchronized(STAR_COUNTER_STREAM_CODEC));

    public static BoolHolder getBoolHolder(ItemStack stack) {
        BoolHolder dataComp = (BoolHolder)stack.get(BOOL_HOLDER.get());
        if (dataComp == null) {
            BoolHolder holder = new BoolHolder(false);
            stack.set(BOOL_HOLDER.get(), (Object)holder);
            return holder;
        }
        return dataComp;
    }

    public static VectorDequeHolder getVecDeque(ItemStack stack) {
        VectorDequeHolder dataComp = (VectorDequeHolder)stack.get(VECTOR_DEQUE_HOLDER.get());
        if (dataComp == null) {
            VectorDequeHolder holder = new VectorDequeHolder(10);
            stack.set(VECTOR_DEQUE_HOLDER.get(), (Object)holder);
            return holder;
        }
        return dataComp;
    }

    public static IntegerCounter getIntegerCounter(ItemStack stack) {
        IntegerCounter dataComp = (IntegerCounter)stack.get(INT_COUNTER.get());
        if (dataComp == null) {
            IntegerCounter counter = new IntegerCounter(0);
            stack.set(INT_COUNTER.get(), (Object)counter);
            return counter;
        }
        return dataComp;
    }

    public static IntegerCounter getAltIntegerCounter(ItemStack stack) {
        IntegerCounter dataComp = (IntegerCounter)stack.get(ALT_INT_COUNTER.get());
        if (dataComp == null) {
            IntegerCounter counter = new IntegerCounter(0);
            stack.set(ALT_INT_COUNTER.get(), (Object)counter);
            return counter;
        }
        return dataComp;
    }

    public static IntegerCounter getAltAltIntegerCounter(ItemStack stack) {
        IntegerCounter dataComp = (IntegerCounter)stack.get(ALT_ALT_INT_COUNTER.get());
        if (dataComp == null) {
            IntegerCounter counter = new IntegerCounter(0);
            stack.set(ALT_ALT_INT_COUNTER.get(), (Object)counter);
            return counter;
        }
        return dataComp;
    }

    public static StarCounter getStarCounter(ItemStack stack) {
        StarCounter dataComp = (StarCounter)stack.get(STAR_COUNTER.get());
        if (dataComp == null) {
            StarCounter counter = new StarCounter(0, 0);
            stack.set(STAR_COUNTER.get(), (Object)counter);
            return counter;
        }
        return dataComp;
    }

    public static LocationHolder getRandomLocation(ItemStack stack) {
        LocationHolder dataComp = (LocationHolder)stack.get(LOCATION_HOLDER.get());
        if (dataComp == null) {
            Random rand = new Random();
            LocationHolder holder = new LocationHolder(rand.nextInt(2001) - 1000, rand.nextInt(20) + 300, rand.nextInt(2001) - 1000);
            stack.set(LOCATION_HOLDER.get(), (Object)holder);
            return holder;
        }
        return dataComp;
    }

    public static LocationHolder getLocation(ItemStack stack) {
        LocationHolder dataComp = (LocationHolder)stack.get(LOCATION_HOLDER.get());
        if (dataComp == null) {
            Random rand = new Random();
            LocationHolder holder = new LocationHolder(0.0, 0.0, 0.0);
            stack.set(LOCATION_HOLDER.get(), (Object)holder);
            return holder;
        }
        return dataComp;
    }

    public static LocationHolder getTripleStorage(ItemStack stack) {
        LocationHolder dataComp = (LocationHolder)stack.get(THREE_INT_HOLDER.get());
        if (dataComp == null) {
            Random rand = new Random();
            LocationHolder holder = new LocationHolder(0.0, 0.0, 0.0);
            stack.set(THREE_INT_HOLDER.get(), (Object)holder);
            return holder;
        }
        return dataComp;
    }
}

