/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.effects;

import com.blorb.morerelics.MoreRelics;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLivingEvent;

public class Static
extends MobEffect {
    public Static() {
        super(MobEffectCategory.HARMFUL, 0xA9A9A9);
    }

    @EventBusSubscriber(modid="morerelics", value={Dist.CLIENT})
    public static class ClientEvent {
        private static final Map<LivingEntityRenderer<?, ?>, Float> previousShadows = new WeakHashMap();

        @SubscribeEvent
        public static void onRender(RenderLivingEvent.Pre<?, ?> event) {
            LivingEntity entityBeingRendered;
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer localPlayer = mc.player;
            if (localPlayer == null) {
                return;
            }
            if (localPlayer.hasEffect(MoreRelics.STATIC) && (entityBeingRendered = event.getEntity()) != localPlayer) {
                LivingEntityRenderer renderer = event.getRenderer();
                previousShadows.putIfAbsent(renderer, Float.valueOf(renderer.shadowRadius));
                renderer.shadowRadius = 0.0f;
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onRenderPost(RenderLivingEvent.Post<?, ?> event) {
            LivingEntityRenderer renderer = event.getRenderer();
            Float original = previousShadows.remove(renderer);
            if (original != null) {
                renderer.shadowRadius = original.floatValue();
            }
        }
    }
}

