/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber
public class CrownOfTheLegend
extends MoreRelicBase {
    public CrownOfTheLegend(Item.Properties properties) {
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"pig_king").stat(StatData.builder((String)"perch").initialValue(0.2, 0.4).upgradeModifier(UpgradeOperation.ADD, 0.1).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(3).requiredLevel(0).build()).ability(AbilityData.builder((String)"never_die").stat(StatData.builder((String)"potency").initialValue(0.1, 0.2).upgradeModifier(UpgradeOperation.ADD, 0.02).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(5).requiredLevel(3).build()).build()).leveling(LevelingData.builder().maxLevel(8).initialCost(100).step(40).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"pig_king").build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.BASTION, LootEntries.THE_NETHER}).build()).build();
    }

    @SubscribeEvent
    public static void onPlayerAttackPre(LivingIncomingDamageEvent event) {
        Player player;
        block3: {
            block2: {
                Entity entity = event.getSource().getEntity();
                if (!(entity instanceof Player)) break block2;
                player = (Player)entity;
                if (!player.level().isClientSide) break block3;
            }
            return;
        }
        float damageMultiplier = (float)EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.CROWN_OF_THE_LEGEND.get())).stream().mapToDouble(stack -> {
            CrownOfTheLegend item = (CrownOfTheLegend)stack.getItem();
            if (!item.isAbilityUnlocked((ItemStack)stack, "pig_king")) {
                return 0.0;
            }
            if (!CrownOfTheLegend.isPig(event.getEntity())) {
                return 0.0;
            }
            return item.getStatValue((ItemStack)stack, "pig_king", "perch");
        }).sum();
        event.setAmount(event.getAmount() * (1.0f + damageMultiplier));
    }

    @SubscribeEvent
    public static void onPlayerAttackPost(LivingDamageEvent.Pre event) {
        Player player;
        block3: {
            block2: {
                Entity entity = event.getSource().getEntity();
                if (!(entity instanceof Player)) break block2;
                player = (Player)entity;
                if (!player.level().isClientSide) break block3;
            }
            return;
        }
        float healthToHeal = (float)EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.CROWN_OF_THE_LEGEND.get())).stream().mapToDouble(stack -> {
            CrownOfTheLegend item = (CrownOfTheLegend)stack.getItem();
            if (item.isAbilityUnlocked((ItemStack)stack, "pig_king") && CrownOfTheLegend.isPig(event.getEntity())) {
                item.spreadRelicExperience((LivingEntity)player, (ItemStack)stack, 5);
            }
            if (!item.isAbilityUnlocked((ItemStack)stack, "never_die")) {
                return 0.0;
            }
            double potency = item.getStatValue((ItemStack)stack, "never_die", "potency");
            return (double)((1.0f - player.getHealth() / player.getMaxHealth()) * event.getNewDamage()) * potency;
        }).sum();
        player.heal(healthToHeal);
    }

    private static boolean isPig(LivingEntity entity) {
        return entity instanceof AbstractPiglin || entity instanceof ZombifiedPiglin || entity instanceof HoglinBase || entity instanceof Pig;
    }
}

