/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.dataComponents.DataComponentHandler;
import com.blorb.morerelics.dataComponents.IntegerCounter;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class MadeInHeaven
extends MoreRelicBase {
    private final int experienceTimer = 10;

    public MadeInHeaven(Item.Properties properties) {
        super(new Item.Properties().rarity(Rarity.EPIC).stacksTo(1).fireResistant());
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"as_one").maxLevel(8).stat(StatData.builder((String)"multiplier").initialValue(0.1, 0.2).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).upgradeModifier(UpgradeOperation.ADD, 0.025).build()).requiredLevel(0).build()).ability(AbilityData.builder((String)"safeguard").stat(StatData.builder((String)"cooldown").initialValue(500.0, 420.0).upgradeModifier(UpgradeOperation.ADD, -40.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).requiredLevel(5).maxLevel(3).build()).ability(AbilityData.builder((String)"judgement").requiredLevel(10).maxLevel(5).stat(StatData.builder((String)"max_health_damage").initialValue(4.0, 6.0).upgradeModifier(UpgradeOperation.ADD, 0.4).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"min_damage").initialValue(4.0, 6.0).upgradeModifier(UpgradeOperation.ADD, 0.8).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"cooldown").initialValue(28.0, 20.0).upgradeModifier(UpgradeOperation.ADD, -0.8).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).build()).build()).leveling(LevelingData.builder().maxLevel(16).initialCost(200).step(50).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"as_one").initialValue(1).build()).build()).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity.level().isClientSide) {
            return;
        }
        IntegerCounter reviveCounter = DataComponentHandler.getAltIntegerCounter(stack);
        int reviveCooldown = reviveCounter.getCurrent();
        if (reviveCooldown > 1) {
            --reviveCooldown;
        } else if (reviveCooldown == 1) {
            --reviveCooldown;
            MutableComponent message = Component.literal((String)"Safeguard is ready to use again.").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16766720)));
            livingEntity.sendSystemMessage((Component)message);
        }
        reviveCounter.setCurrent(reviveCooldown);
        stack.set(DataComponentHandler.ALT_INT_COUNTER.get(), (Object)reviveCounter);
        float multiplier = (float)this.getStatValue(stack, "as_one", "multiplier");
        IntegerCounter counter = DataComponentHandler.getIntegerCounter(stack);
        int experienceProgress = counter.getCurrent();
        if (10 > experienceProgress) {
            ++experienceProgress;
        } else {
            this.addRelicExperience(livingEntity, stack, 1);
            experienceProgress = 0;
        }
        counter.setCurrent(experienceProgress);
        stack.set(DataComponentHandler.INT_COUNTER.get(), (Object)counter);
        IntegerCounter judgementCounter = DataComponentHandler.getAltAltIntegerCounter(stack);
        int judgementTimer = judgementCounter.getCurrent();
        if (judgementTimer > 0) {
            MoreRelics.LOGGER.debug("" + judgementTimer);
            judgementCounter.setCurrent(judgementTimer - 1);
        }
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.ATTACK_DAMAGE, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.ATTACK_SPEED, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.MAX_HEALTH, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.MINING_EFFICIENCY, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.OXYGEN_BONUS, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.SNEAKING_SPEED, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.SWEEPING_DAMAGE_RATIO, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.LUCK, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.KNOCKBACK_RESISTANCE, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.SUBMERGED_MINING_SPEED, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.BLOCK_BREAK_SPEED, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.BLOCK_INTERACTION_RANGE, (float)(multiplier / 2.0f), (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.ENTITY_INTERACTION_RANGE, (float)(multiplier / 2.0f), (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (stack.getItem() != newStack.getItem()) {
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.ATTACK_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.MINING_EFFICIENCY, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.OXYGEN_BONUS, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.SNEAKING_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.SWEEPING_DAMAGE_RATIO, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.KNOCKBACK_RESISTANCE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.SUBMERGED_MINING_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.LUCK, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.BLOCK_BREAK_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.BLOCK_INTERACTION_RANGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.ENTITY_INTERACTION_RANGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingIncomingDamageEvent event) {
        Player player;
        block5: {
            block4: {
                Entity entity = event.getSource().getEntity();
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                if (!player.level().isClientSide) break block5;
            }
            return;
        }
        float extra_damage = (float)EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.MADE_IN_HEAVEN.get())).stream().mapToDouble(stack -> {
            MadeInHeaven item = (MadeInHeaven)stack.getItem();
            IntegerCounter judgementCounter = DataComponentHandler.getAltAltIntegerCounter(stack);
            int judgementCooldown = judgementCounter.getCurrent();
            if (judgementCooldown != 0) {
                return 0.0;
            }
            if (!item.isAbilityUnlocked((ItemStack)stack, "judgement")) {
                return 0.0;
            }
            double perch = item.getStatValue((ItemStack)stack, "judgement", "max_health_damage");
            double min = item.getStatValue((ItemStack)stack, "judgement", "min_damage");
            judgementCounter.setCurrent((int)(item.getStatValue((ItemStack)stack, "judgement", "cooldown") * 20.0));
            return (float)Math.round(Math.max(min, perch * (double)event.getEntity().getMaxHealth() / 100.0) * 100.0) / 100.0f;
        }).sum();
        if (extra_damage == 0.0f) {
            return;
        }
        MadeInHeaven.spawnHolyFireParticles(event.getEntity().level(), event.getEntity().position());
        event.setAmount(event.getAmount() + extra_damage);
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        Player player;
        block5: {
            block4: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block4;
                player = (Player)livingEntity;
                if (!player.level().isClientSide) break block5;
            }
            return;
        }
        int shouldPrevent = EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.MADE_IN_HEAVEN.get())).stream().mapToInt(stack -> {
            boolean result;
            MadeInHeaven item = (MadeInHeaven)stack.getItem();
            IntegerCounter counter = DataComponentHandler.getAltIntegerCounter(stack);
            boolean bl = result = item.isAbilityUnlocked((ItemStack)stack, "safeguard") && counter.getCurrent() <= 0;
            if (result) {
                counter.setCurrent((int)Math.round(item.getStatValue((ItemStack)stack, "safeguard", "cooldown") * 20.0));
                stack.set(DataComponentHandler.ALT_INT_COUNTER.get(), (Object)counter);
                return 1;
            }
            return 0;
        }).sum();
        if (shouldPrevent == 1) {
            event.setCanceled(true);
            player.setHealth(player.getMaxHealth() / 2.0f);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.GLASS_BREAK, SoundSource.MASTER, 1.2f, 0.4f);
            MutableComponent message = Component.literal((String)"Safeguard has shielded you from death and is now on cooldown.").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16766720)));
            player.sendSystemMessage((Component)message);
        }
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.translatable((String)"tooltip.morerelics.made_in_heaven.source").withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.ITALIC));
        return list;
    }

    private static void spawnHolyFireParticles(Level level, Vec3 position) {
        int particleCount = 40;
        level.playSound(null, position.x, position.y, position.z, MoreRelics.JUDGEMENT, SoundSource.MASTER, 0.4f, 1.0f);
        ServerLevel sevLevel = (ServerLevel)level;
        List players = level.players();
        for (ServerPlayer player : players) {
            sevLevel.sendParticles(player, (ParticleOptions)MoreRelics.HOLY_FIRE.get(), true, position.x, position.y + 1.0, position.z, particleCount, 0.0, 0.0, 0.0, 0.05);
        }
    }
}

