/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.dataComponents.DataComponentHandler;
import com.blorb.morerelics.dataComponents.IntegerCounter;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class MoodWorm
extends MoreRelicBase {
    public static int MOOD_SWAP_SECONDS = 600;

    public MoodWorm(Item.Properties properties) {
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"moody").stat(StatData.builder((String)"multip").initialValue(0.1, 0.15).upgradeModifier(UpgradeOperation.ADD, 0.02).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"reduction").initialValue(10.0, 14.0).upgradeModifier(UpgradeOperation.ADD, 2.2).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(5).requiredLevel(0).build()).ability(AbilityData.builder((String)"tranquillity").maxLevel(0).requiredLevel(5).build()).build()).leveling(LevelingData.builder().maxLevel(5).initialCost(20).step(20).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"moody").initialValue(1).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.WILDCARD}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide) {
            return;
        }
        IntegerCounter currentMoodCounter = DataComponentHandler.getAltIntegerCounter(stack);
        IntegerCounter moodTimerCounter = DataComponentHandler.getIntegerCounter(stack);
        boolean unlockedTranquility = this.isAbilityUnlocked(stack, "tranquillity");
        int currentMood = currentMoodCounter.current;
        int moodTimer = moodTimerCounter.getCurrent();
        if (0 < moodTimer) {
            --moodTimer;
        } else {
            this.addRelicExperience(livingEntity, stack, 20);
            currentMood = this.swapMood(currentMoodCounter, unlockedTranquility);
            moodTimer = MOOD_SWAP_SECONDS * 20;
        }
        moodTimerCounter.setCurrent(moodTimer);
        float multip = (float)this.getStatValue(stack, "moody", "multip");
        EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.LUCK, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.KNOCKBACK_RESISTANCE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
        if (currentMood == 0 || currentMood == 3) {
            EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.ATTACK_DAMAGE, (float)multip, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
        if (currentMood == 1 || currentMood == 3) {
            EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (float)multip, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.LUCK, (float)multip, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
        if (currentMood == 2 || currentMood == 3) {
            EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.KNOCKBACK_RESISTANCE, (float)0.5f, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (stack.getItem() != newStack.getItem()) {
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.LUCK, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.KNOCKBACK_RESISTANCE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
        }
    }

    private int swapMood(IntegerCounter moodCounter, boolean didUnlockTranquillity) {
        Random rand = new Random();
        int highestMood = didUnlockTranquillity ? 3 : 2;
        int nextMood = rand.nextInt(highestMood + 1);
        if (nextMood == moodCounter.getCurrent()) {
            nextMood = nextMood == highestMood ? 0 : nextMood + 1;
        }
        moodCounter.setCurrent(nextMood);
        return nextMood;
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingIncomingDamageEvent event) {
        Player player;
        block7: {
            block6: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block6;
                player = (Player)livingEntity;
                if (!player.level().isClientSide) break block7;
            }
            return;
        }
        double reduction = EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.MOODWORM.get())).stream().mapToDouble(stack -> {
            MoodWorm item = (MoodWorm)stack.getItem();
            int currentMood = DataComponentHandler.getAltIntegerCounter(stack).getCurrent();
            if (currentMood != 2 && currentMood != 3) {
                return 0.0;
            }
            return item.getStatValue((ItemStack)stack, "moody", "reduction");
        }).sum();
        if (reduction > 60.0) {
            reduction = 60.0;
        } else if (reduction < 0.0) {
            reduction = 0.0;
        }
        event.setAmount((float)((double)event.getAmount() * (100.0 - reduction) / 100.0));
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Post event) {
        Player player;
        block5: {
            block4: {
                Entity entity = event.getSource().getEntity();
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                if (!player.level().isClientSide) break block5;
            }
            return;
        }
        LivingEntity victim = event.getEntity();
        int shouldBurn = EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.MOODWORM.get())).stream().mapToInt(stack -> {
            MoodWorm item = (MoodWorm)stack.getItem();
            int currentMood = DataComponentHandler.getAltIntegerCounter(stack).getCurrent();
            if (currentMood == 0 || currentMood == 3) {
                return 1;
            }
            return 0;
        }).sum();
        if (shouldBurn > 0 && victim.getRemainingFireTicks() < 60) {
            victim.setRemainingFireTicks(60);
        }
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        int currentMood = DataComponentHandler.getAltIntegerCounter(stack).getCurrent();
        if (currentMood == 0) {
            list.add((Component)Component.translatable((String)"tooltip.morerelics.moodworm.furious").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC));
        } else if (currentMood == 1) {
            list.add((Component)Component.translatable((String)"tooltip.morerelics.moodworm.joyful").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.ITALIC));
        } else if (currentMood == 2) {
            list.add((Component)Component.translatable((String)"tooltip.morerelics.moodworm.gloomy").withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC));
        } else if (currentMood == 3) {
            list.add((Component)Component.translatable((String)"tooltip.morerelics.moodworm.tranquillity").withStyle(ChatFormatting.WHITE).withStyle(ChatFormatting.ITALIC));
        }
        return list;
    }
}

