/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.dataComponents.BoolHolder;
import com.blorb.morerelics.dataComponents.DataComponentHandler;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class OpalNecklace
extends MoreRelicBase {
    public OpalNecklace(Item.Properties properties) {
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"bubble_shield").stat(StatData.builder((String)"cooldown").initialValue(300.0, 200.0).upgradeModifier(UpgradeOperation.ADD, -20.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(5).requiredLevel(0).build()).build()).leveling(LevelingData.builder().maxLevel(5).initialCost(120).step(20).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"bubble_shield").build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.DESERT, LootEntries.FROST}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        boolean notified;
        BoolHolder holder = DataComponentHandler.getBoolHolder(stack);
        boolean onCooldown = this.isAbilityOnCooldown(stack, "bubble_shield");
        if (onCooldown != (notified = holder.getBool())) {
            if (!onCooldown) {
                MutableComponent message = Component.literal((String)"Bubble Shield is ready to use again.").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16766720)));
                slotContext.entity().sendSystemMessage((Component)message);
            }
            holder.setBool(onCooldown);
            stack.set(DataComponentHandler.BOOL_HOLDER.get(), (Object)holder);
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingIncomingDamageEvent event) {
        LivingEntity player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        if ((float)player.invulnerableTime > 10.0f && !event.getSource().is(DamageTypeTags.BYPASSES_COOLDOWN) && event.getAmount() <= player.lastHurt) {
            return;
        }
        int block = EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.OPAL_NECKLACE.get())).stream().mapToInt(stack -> {
            OpalNecklace item = (OpalNecklace)stack.getItem();
            if (!item.isAbilityUnlocked((ItemStack)stack, "bubble_shield") || item.isAbilityOnCooldown((ItemStack)stack, "bubble_shield")) {
                return 0;
            }
            item.setAbilityCooldown((ItemStack)stack, "bubble_shield", (int)(item.getStatValue((ItemStack)stack, "bubble_shield", "cooldown") * 20.0));
            item.spreadRelicExperience(player, (ItemStack)stack, 5);
            return 1;
        }).sum();
        if (block >= 1) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.AMETHYST_CLUSTER_BREAK, SoundSource.MASTER, 0.8f, 0.6f);
            player.invulnerableTime = 20;
            player.hurtTime = player.hurtDuration = 10;
            event.setCanceled(true);
        }
    }
}

