/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.dataComponents.DataComponentHandler;
import com.blorb.morerelics.dataComponents.IntegerCounter;
import com.blorb.morerelics.network.SilkCounterPayload;
import com.blorb.morerelics.network.SoarVelocityPayload;
import com.blorb.morerelics.relics.MoreRelicBase;
import com.mojang.blaze3d.systems.RenderSystem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class WeaversSpool
extends MoreRelicBase {
    public static final ResourceLocation SILK_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"morerelics", (String)"textures/gui/silk/background.png");
    public static final ResourceLocation SILK = ResourceLocation.fromNamespaceAndPath((String)"morerelics", (String)"textures/gui/silk/silk.png");
    public static final int BIND_COST = 6;
    public static final int SOAR_COST = 3;
    public static final int UNRAVEL_COST = 7;

    public WeaversSpool(Item.Properties properties) {
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"weaver").stat(StatData.builder((String)"passive_regen_time").initialValue(7.0, 5.0).upgradeModifier(UpgradeOperation.ADD, -0.5).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(3).requiredLevel(0).build()).ability(AbilityData.builder((String)"bind").stat(StatData.builder((String)"healing_amount").initialValue(2.0, 4.0).upgradeModifier(UpgradeOperation.ADD, 0.5).formatValue(value -> Float.valueOf((float)Math.round(value * 2.0) / 2.0f)).build()).maxLevel(3).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).requiredLevel(0).build()).ability(AbilityData.builder((String)"soar").stat(StatData.builder((String)"leap_power").initialValue((double)1.1f, (double)1.3f).upgradeModifier(UpgradeOperation.ADD, (double)0.1f).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"speed_duration").initialValue(7.0, 10.0).upgradeModifier(UpgradeOperation.ADD, 2.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(3).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).requiredLevel(3).build()).ability(AbilityData.builder((String)"unravel").stat(StatData.builder((String)"damage").initialValue(4.0, 6.0).upgradeModifier(UpgradeOperation.ADD, 2.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"slow_duration").initialValue(2.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 0.5).formatValue(value -> Float.valueOf((float)Math.round(value * 2.0) / 2.0f)).build()).maxLevel(3).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).requiredLevel(6).build()).build()).leveling(LevelingData.builder().maxLevel(12).initialCost(140).step(40).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"weaver").build()).build()).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide) {
            return;
        }
        float regen_time = (float)this.getStatValue(stack, "weaver", "passive_regen_time") * 20.0f;
        IntegerCounter integerCounter = DataComponentHandler.getAltIntegerCounter(stack);
        int regenProgress = integerCounter.getCurrent();
        if ((float)regenProgress < regen_time) {
            ++regenProgress;
        } else {
            regenProgress = 0;
            IntegerCounter silkCounter = DataComponentHandler.getIntegerCounter(stack);
            int currentSilk = silkCounter.getCurrent();
            if (currentSilk < 3) {
                silkCounter.setCurrent(currentSilk + 1);
                this.spreadRelicExperience((LivingEntity)player, stack, 3);
                this.sendSilkCounterPayload(player, currentSilk + 1);
            }
        }
        integerCounter.setCurrent(regenProgress);
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (player.level().isClientSide) {
            return;
        }
        IntegerCounter counter = DataComponentHandler.getIntegerCounter(stack);
        int currentSilk = counter.getCurrent();
        if (ability.equals("bind") && currentSilk >= 6) {
            this.applyBind(stack, player, counter, currentSilk);
        } else if (ability.equals("soar") && currentSilk >= 3) {
            this.applySoar(stack, player, counter, currentSilk);
        } else if (ability.equals("unravel") && currentSilk >= 7) {
            this.applyUnravel(stack, player, counter, currentSilk);
        }
    }

    private void applyBind(ItemStack stack, Player player, IntegerCounter counter, int currentSilk) {
        this.setAbilityCooldown(stack, "bind", 20);
        counter.setCurrent(currentSilk - 6);
        player.heal((float)this.getStatValue(stack, "bind", "healing_amount"));
        player.level().playSound(null, player.position().x, player.position().y, player.position().z, MoreRelics.HEAL, SoundSource.MASTER, 1.1f, 1.0f);
        player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 80, 0));
        this.sendSilkCounterPayload(player, currentSilk - 6);
    }

    private void applySoar(ItemStack stack, Player player, IntegerCounter counter, int currentSilk) {
        this.setAbilityCooldown(stack, "soar", 20);
        counter.setCurrent(currentSilk - 3);
        player.level().playSound(null, player.position().x, player.position().y, player.position().z, SoundEvents.ENDER_DRAGON_FLAP, SoundSource.MASTER, 0.7f, 1.2f);
        Vec3 lookDirection = player.getLookAngle().scale(this.getStatValue(stack, "soar", "leap_power"));
        player.resetFallDistance();
        SoarVelocityPayload soarPayload = new SoarVelocityPayload(lookDirection.x, lookDirection.y, lookDirection.z);
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)soarPayload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, (int)(this.getStatValue(stack, "soar", "speed_duration") * 20.0), 0));
        this.sendSilkCounterPayload(player, currentSilk - 3);
    }

    private void applyUnravel(ItemStack stack, Player player, IntegerCounter counter, int currentSilk) {
        this.setAbilityCooldown(stack, "unravel", 20);
        counter.setCurrent(currentSilk - 7);
        Vec3 center = player.position();
        float radius = 4.0f;
        float damage = (float)this.getStatValue(stack, "unravel", "damage");
        float slowDuration = (float)this.getStatValue(stack, "unravel", "slow_duration");
        this.spawnSilkParticles(player.level(), player.position(), 1, radius);
        AABB area = new AABB(center.x - (double)radius, center.y - (double)radius, center.z - (double)radius, center.x + (double)radius, center.y + (double)radius, center.z + (double)radius);
        List detectedEntities = player.level().getEntities((Entity)player, area);
        player.level().playSound(null, player.position().x, player.position().y, player.position().z, SoundEvents.FIREWORK_ROCKET_BLAST, SoundSource.MASTER, 0.7f, 0.6f);
        for (Entity detected : detectedEntities) {
            if (!(detected instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)detected;
            if (player == detected) continue;
            livingEntity.hurt(new DamageSource(livingEntity.damageSources().generic().typeHolder(), (Entity)player, (Entity)player), damage);
            livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, (int)(slowDuration * 20.0f), 2));
        }
        this.sendSilkCounterPayload(player, currentSilk - 7);
    }

    private void sendSilkCounterPayload(Player player, int newSilkAmount) {
        SilkCounterPayload payload = new SilkCounterPayload(newSilkAmount);
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Player player;
        block3: {
            block2: {
                Entity entity = event.getSource().getEntity();
                if (!(entity instanceof Player)) break block2;
                player = (Player)entity;
                if (!player.level().isClientSide) break block3;
            }
            return;
        }
        EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.WEAVERS_SPOOL.get())).forEach(stack -> {
            WeaversSpool item = (WeaversSpool)stack.getItem();
            IntegerCounter silkCounter = DataComponentHandler.getIntegerCounter(stack);
            int currentSilkAmount = silkCounter.getCurrent();
            if (currentSilkAmount < 10) {
                silkCounter.setCurrent(currentSilkAmount + 1);
                item.spreadRelicExperience((LivingEntity)player, (ItemStack)stack, 3);
                SilkCounterPayload payload = new SilkCounterPayload(silkCounter.getCurrent());
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    private void spawnSilkParticles(Level level, Vec3 position, int amplifier, float radius) {
        int particleCount = 30 + amplifier * 60;
        if (particleCount > 400) {
            particleCount = 400;
        }
        ServerLevel sevLevel = (ServerLevel)level;
        List players = level.players();
        for (ServerPlayer player : players) {
            sevLevel.sendParticles(player, (ParticleOptions)ParticleTypes.END_ROD, true, position.x, position.y + 1.0, position.z, particleCount, 0.0, 0.0, 0.0, 0.025 * (double)radius);
        }
    }

    @EventBusSubscriber(modid="morerelics", value={Dist.CLIENT})
    public static class ClientRender {
        @SubscribeEvent
        public static void renderSilk(RenderGuiEvent.Pre event) {
            boolean hasWeaver;
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            if (!player.level().isClientSide) {
                return;
            }
            boolean bl = hasWeaver = !EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.WEAVERS_SPOOL.get())).isEmpty();
            if (!hasWeaver) {
                return;
            }
            OptionalInt silkAmount = EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.WEAVERS_SPOOL.get())).stream().mapToInt(stack -> {
                WeaversSpool item = (WeaversSpool)stack.getItem();
                return DataComponentHandler.getIntegerCounter(stack).getCurrent();
            }).max();
            if (silkAmount.isPresent()) {
                ClientRender.drawSilkBar(event.getGuiGraphics(), event.getGuiGraphics().guiWidth(), event.getGuiGraphics().guiHeight(), silkAmount.getAsInt());
            }
        }

        public static void drawSilkBar(GuiGraphics guiGraphics, int screenWidth, int screenHeight, int silkLevel) {
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            minecraft.getTextureManager().bindForSetup(SILK_BACKGROUND);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SILK_BACKGROUND);
            int barWidth = 20;
            int barHeight = 53;
            int left = screenWidth - (barWidth + 5);
            int top = screenHeight - (barHeight + 5);
            guiGraphics.blit(SILK_BACKGROUND, left, top, 0.0f, 0.0f, barWidth, barHeight, barWidth, barHeight);
            ClientRender.drawSilk(guiGraphics, left, top, barWidth, barHeight, silkLevel);
        }

        public static void drawSilk(GuiGraphics guiGraphics, int left, int top, int barWidth, int barHeight, int silkLevel) {
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            minecraft.getTextureManager().bindForSetup(SILK);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SILK);
            int silkHeight = 5;
            int silkStart = top + barHeight - 6 - silkHeight;
            for (int i = 0; i < silkLevel; ++i) {
                guiGraphics.blit(SILK, left, silkStart, 0.0f, 0.0f, barWidth, silkHeight, barWidth, silkHeight);
                silkStart -= 4;
            }
        }
    }
}

