/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.dataComponents.DataComponentHandler;
import com.blorb.morerelics.dataComponents.IntegerCounter;
import com.blorb.morerelics.dataComponents.LocationHolder;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class WhisperingAmulet
extends MoreRelicBase {
    public Random rand = new Random();

    public WhisperingAmulet(Item.Properties properties) {
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"ascend_heaven").maxLevel(0).requiredLevel(0).build()).build()).leveling(LevelingData.builder().maxLevel(0).build()).build();
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        DataComponentHandler.getRandomLocation(stack);
        super.onEquip(slotContext, prevStack, stack);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        block12: {
            block11: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block11;
                player = (Player)livingEntity;
                if (!player.level().isClientSide) break block12;
            }
            return;
        }
        LocationHolder holder = DataComponentHandler.getRandomLocation(stack);
        Vec3 location = new Vec3(holder.x, holder.y, holder.z);
        IntegerCounter counter = DataComponentHandler.getIntegerCounter(stack);
        int ascendStatus = counter.getCurrent();
        if (ascendStatus > 0) {
            if (ascendStatus > 300) {
                MutableComponent message = Component.literal((String)"The amulet transcends, ascending to its true form.").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16766720)));
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TOTEM_USE, SoundSource.MASTER, 1.2f, 0.4f);
                player.sendSystemMessage((Component)message);
                player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 1800));
                EntityUtils.addItem((Player)player, (ItemStack)MoreRelics.MADE_IN_HEAVEN.toStack());
                stack.setCount(0);
            } else {
                if (++ascendStatus % 10 == 0) {
                    this.spawnHolyParticles(player.level(), player.getPosition(0.0f));
                }
                counter.setCurrent(ascendStatus);
                stack.set(DataComponentHandler.INT_COUNTER.get(), (Object)counter);
            }
        } else if (player.level().dimension() == Level.OVERWORLD && location.distanceToSqr(player.getX(), player.getY(), player.getZ()) < 1.0) {
            this.ascend(stack, (LivingEntity)player);
        } else if (player.level().dimension() == Level.OVERWORLD && this.rand.nextInt(6000) == 1) {
            this.whisper((LivingEntity)player, location);
        }
    }

    private void ascend(ItemStack stack, LivingEntity player) {
        IntegerCounter counter = DataComponentHandler.getIntegerCounter(stack);
        player.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 300, 6));
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.MASTER, 1.5f, 0.4f);
        int ascendStatus = 1;
        counter.setCurrent(ascendStatus);
        stack.set(DataComponentHandler.INT_COUNTER.get(), (Object)counter);
    }

    private void whisper(LivingEntity player, Vec3 location) {
        int randomInt = this.rand.nextInt(8);
        String locString = "(X: " + location.x + " Y: " + location.y + " Z: " + location.z + ")";
        MutableComponent message = randomInt == 0 ? Component.literal((String)("Bring me to " + locString + ". Let us ascend together.")).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-4276546)).withItalic(Boolean.valueOf(true))) : (randomInt == 1 ? Component.literal((String)("Lead me to " + locString + ". Our journey awaits.")).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-4276546)).withItalic(Boolean.valueOf(true))) : (randomInt == 2 ? Component.literal((String)("Direct your steps to " + locString + ". The ascent begins.")).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-4276546)).withItalic(Boolean.valueOf(true))) : (randomInt == 3 ? Component.literal((String)("Can you feel the pull? Lead me to " + locString + ".")).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-4276546)).withItalic(Boolean.valueOf(true))) : (randomInt == 4 ? Component.literal((String)("The world seems to hold its breath, as though waiting for us to act. Accompany me the way to the place where destiny lies at " + locString + ".")).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-4276546)).withItalic(Boolean.valueOf(true))) : (randomInt == 5 ? Component.literal((String)("A new horizon lies ahead. Follow the path to " + locString + " and see where it leads.")).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-4276546)).withItalic(Boolean.valueOf(true))) : (randomInt == 6 ? Component.literal((String)("The path is clear, " + player.getName().getString() + ". Make your way to " + locString + ".")).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-4276546)).withItalic(Boolean.valueOf(true))) : Component.literal((String)("Do not delay our ascension any longer, " + player.getName().getString() + ". Go to " + locString + " now.")).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-4276546)).withItalic(Boolean.valueOf(true)))))))));
        player.sendSystemMessage((Component)message);
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.translatable((String)"tooltip.morerelics.whispering_amulet.source").withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.ITALIC));
        return list;
    }

    private void spawnHolyParticles(Level level, Vec3 position) {
        int particleCount = 10;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            double radius = Math.random() * 1.5 + 0.8;
            double x = position.x + radius * Math.cos(angle);
            double y = position.y + Math.random() * 2.5;
            double z = position.z + radius * Math.sin(angle);
            ServerLevel sevLevel = (ServerLevel)level;
            List players = level.players();
            for (ServerPlayer player : players) {
                sevLevel.sendParticles(player, (ParticleOptions)ParticleTypes.END_ROD, true, x, y, z, particleCount, 0.0, 0.0, 0.0, 0.3);
            }
        }
    }
}

