/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelicUtils;
import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber
public class TyrantMask
extends MoreRelicBase {
    final int requiredDistance = 15000;
    final int requiredKills = 300;
    final int requiredBlocks = 1200;

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"regrets").stat(StatData.builder((String)"debuff").initialValue(20.0, 20.0).build()).build()).ability(AbilityData.builder((String)"revenge").build()).ability(AbilityData.builder((String)"monotony").build()).ability(AbilityData.builder((String)"futility").build()).build()).leveling(LevelingData.builder().maxLevel(1).initialCost(100).step(30).build()).loot(LootData.builder().entry(LootCollections.BASTION).build()).build();
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
    }

    @SubscribeEvent
    public static void onKill(LivingDeathEvent event) {
        Player player;
        block3: {
            block2: {
                Entity entity = event.getSource().m_7639_();
                if (!(entity instanceof Player)) break block2;
                player = (Player)entity;
                if (!player.m_9236_().f_46443_) break block3;
            }
            return;
        }
        MoreRelicUtils.actuallyGetEquippedRelics((LivingEntity)player).forEach(stack -> {
            Item patt3774$temp = stack.m_41720_();
            if (!(patt3774$temp instanceof TyrantMask)) {
                return;
            }
            TyrantMask item = (TyrantMask)patt3774$temp;
            CompoundTag tag = stack.m_41784_();
            int kills = tag.m_128451_("morerelics_kills");
            if (kills < item.requiredKills) {
                tag.m_128405_("morerelics_kills", ++kills);
                item.checkAndChange((ItemStack)stack, player);
            }
        });
    }

    @SubscribeEvent
    public static void onPlace(BlockEvent.EntityPlaceEvent event) {
        Player player;
        block3: {
            block2: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Player)) break block2;
                player = (Player)entity;
                if (!player.m_9236_().f_46443_) break block3;
            }
            return;
        }
        MoreRelicUtils.actuallyGetEquippedRelics((LivingEntity)player).forEach(stack -> {
            Item patt4485$temp = stack.m_41720_();
            if (!(patt4485$temp instanceof TyrantMask)) {
                return;
            }
            TyrantMask item = (TyrantMask)patt4485$temp;
            CompoundTag tag = stack.m_41784_();
            int blocks = tag.m_128451_("morerelics_blocks");
            if (blocks < item.requiredBlocks) {
                tag.m_128405_("morerelics_blocks", ++blocks);
                item.checkAndChange((ItemStack)stack, player);
            }
        });
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        double distance = tag.m_128459_("morerelics_distance");
        LivingEntity entity = slotContext.entity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (distance < 15000.0) {
            Vec3 playerPos = entity.m_20318_(0.0f);
            tag.m_128347_("morerelics_x", playerPos.f_82479_);
            tag.m_128347_("morerelics_y", playerPos.f_82480_);
            tag.m_128347_("morerelics_z", playerPos.f_82481_);
            tag.m_128347_("morerelics_distance", distance += Math.sqrt(entity.m_20275_(tag.m_128459_("morerelics_x"), tag.m_128459_("morerelics_y"), tag.m_128459_("morerelics_z"))));
            if (this.checkAndChange(stack, player)) {
                return;
            }
        }
        EntityUtils.applyAttribute((LivingEntity)entity, (ItemStack)stack, (Attribute)Attributes.f_22279_, (float)(-((float)this.getAbilityValue(stack, "regrets", "debuff")) / 100.0f), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.applyAttribute((LivingEntity)entity, (ItemStack)stack, (Attribute)Attributes.f_22281_, (float)(-((float)this.getAbilityValue(stack, "regrets", "debuff")) / 100.0f), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.applyAttribute((LivingEntity)entity, (ItemStack)stack, (Attribute)Attributes.f_22283_, (float)(-((float)this.getAbilityValue(stack, "regrets", "debuff")) / 100.0f), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        LivingEntity entity = slotContext.entity();
        Vec3 playerPos = entity.m_20318_(0.0f);
        tag.m_128347_("morerelics_x", playerPos.f_82479_);
        tag.m_128347_("morerelics_y", playerPos.f_82480_);
        tag.m_128347_("morerelics_z", playerPos.f_82481_);
        super.onEquipFromUse(slotContext, stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (stack.m_41720_() != newStack.m_41720_()) {
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Attribute)Attributes.f_22279_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Attribute)Attributes.f_22283_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Attribute)Attributes.f_22281_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
    }

    private boolean checkAndChange(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128459_("morerelics_distance") >= 15000.0 && tag.m_128451_("morerelics_kills") >= 300 && tag.m_128451_("morerelics_blocks") >= 1200) {
            EntityUtils.addItem((Player)player, (ItemStack)new ItemStack((ItemLike)MoreRelics.KING_CRIMSON.get()));
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12394_, SoundSource.MASTER, 1.2f, 0.3f);
            MutableComponent message = Component.m_237113_((String)"The trapped souls within the mask are freed.").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16766720)));
            player.m_213846_((Component)message);
            this.spawnSoulParticles(player.m_9236_(), player.m_20182_());
            EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)Attributes.f_22279_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)Attributes.f_22283_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Attribute)Attributes.f_22281_, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL);
            stack.m_41764_(0);
            return true;
        }
        return false;
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        CompoundTag tag = stack.m_41784_();
        list.add((Component)Component.m_237113_((String)("Distance Travelled: " + (int)tag.m_128459_("morerelics_distance") + "/15000")).m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.ITALIC));
        list.add((Component)Component.m_237113_((String)("Enemies Killed: " + tag.m_128451_("morerelics_kills") + "/300")).m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.ITALIC));
        list.add((Component)Component.m_237113_((String)("Blocks Placed: " + tag.m_128451_("morerelics_blocks") + "/1200")).m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.ITALIC));
        return list;
    }

    private void spawnSoulParticles(Level level, Vec3 position) {
        int particleCount = 50;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            double radius = Math.random() * 1.5 + 0.8;
            double x = position.f_82479_ + radius * Math.cos(angle);
            double y = position.f_82480_ + Math.random() * 2.5;
            double z = position.f_82481_ + radius * Math.sin(angle);
            ServerLevel sevLevel = (ServerLevel)level;
            List players = level.m_6907_();
            for (ServerPlayer player : players) {
                sevLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123746_, true, x, y, z, particleCount, 0.0, 0.0, 0.0, 0.7);
            }
        }
    }
}

