/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.api.commands;

import com.hypherionmc.craterlib.CraterConstants;
import com.hypherionmc.craterlib.compat.LuckPermsCompat;
import com.hypherionmc.craterlib.core.platform.LoaderType;
import com.hypherionmc.craterlib.core.platform.ModloaderEnvironment;
import com.hypherionmc.craterlib.nojang.authlib.BridgedGameProfile;
import com.hypherionmc.craterlib.nojang.commands.BridgedCommandSourceStack;
import com.hypherionmc.craterlib.nojang.world.entity.player.BridgedPlayer;
import com.hypherionmc.craterlib.utils.TriConsumer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;

public class CraterCommand {
    private final LiteralArgumentBuilder<class_2168> mojangCommand;
    private int permLevel = 4;
    private String luckPermNode = "";

    CraterCommand(LiteralArgumentBuilder<class_2168> cmd) {
        this.mojangCommand = cmd;
    }

    public static CraterCommand literal(String commandName) {
        return new CraterCommand((LiteralArgumentBuilder<class_2168>)class_2170.method_9247((String)commandName));
    }

    public CraterCommand requiresPermission(int perm) {
        this.permLevel = perm;
        this.mojangCommand.requires(this::checkPermission);
        return this;
    }

    public CraterCommand withNode(String key) {
        this.luckPermNode = key;
        return this;
    }

    public CraterCommand then(CraterCommand child) {
        this.mojangCommand.then(child.mojangCommand);
        return this;
    }

    public CraterCommand withGameProfilesArgument(String key, CommandExecutorWithArgs<List<BridgedGameProfile>> executor) {
        this.mojangCommand.then(class_2170.method_9244((String)key, (ArgumentType)class_2191.method_9329()).executes(context -> executor.run(BridgedPlayer.of((class_1657)((class_2168)context.getSource()).method_9207()), class_2191.method_9330((CommandContext)context, (String)key).stream().map(BridgedGameProfile::of).toList(), BridgedCommandSourceStack.of((class_2168)context.getSource()))));
        return this;
    }

    public CraterCommand withBoolArgument(String key, CommandExecutorWithArgs<Boolean> executor) {
        this.mojangCommand.then(class_2170.method_9244((String)key, (ArgumentType)BoolArgumentType.bool()).executes(context -> executor.run(BridgedPlayer.of((class_1657)((class_2168)context.getSource()).method_9207()), BoolArgumentType.getBool((CommandContext)context, (String)key), BridgedCommandSourceStack.of((class_2168)context.getSource()))));
        return this;
    }

    public CraterCommand withWordArgument(String key, CommandExecutorWithArgs<String> executor) {
        this.mojangCommand.then(class_2170.method_9244((String)key, (ArgumentType)StringArgumentType.word()).executes(context -> executor.run(BridgedPlayer.of((class_1657)((class_2168)context.getSource()).method_9207()), StringArgumentType.getString((CommandContext)context, (String)key), BridgedCommandSourceStack.of((class_2168)context.getSource()))));
        return this;
    }

    public CraterCommand withStringArgument(String key, CommandExecutorWithArgs<String> executor) {
        this.mojangCommand.then(class_2170.method_9244((String)key, (ArgumentType)StringArgumentType.string()).executes(context -> executor.run(BridgedPlayer.of((class_1657)((class_2168)context.getSource()).method_9207()), StringArgumentType.getString((CommandContext)context, (String)key), BridgedCommandSourceStack.of((class_2168)context.getSource()))));
        return this;
    }

    public CraterCommand withPhraseArgument(String key, CommandExecutorWithArgs<String> executor) {
        this.mojangCommand.then(class_2170.method_9244((String)key, (ArgumentType)StringArgumentType.greedyString()).executes(context -> executor.run(BridgedPlayer.of((class_1657)((class_2168)context.getSource()).method_9207()), StringArgumentType.getString((CommandContext)context, (String)key), BridgedCommandSourceStack.of((class_2168)context.getSource()))));
        return this;
    }

    public CraterCommand withIntegerArgument(String key, CommandExecutorWithArgs<Integer> executor) {
        this.mojangCommand.then(class_2170.method_9244((String)key, (ArgumentType)IntegerArgumentType.integer()).executes(context -> executor.run(BridgedPlayer.of((class_1657)((class_2168)context.getSource()).method_9207()), IntegerArgumentType.getInteger((CommandContext)context, (String)key), BridgedCommandSourceStack.of((class_2168)context.getSource()))));
        return this;
    }

    public CraterCommand execute(SingleCommandExecutor<BridgedCommandSourceStack> executor) {
        this.mojangCommand.executes(context -> executor.run(BridgedCommandSourceStack.of((class_2168)context.getSource())));
        return this;
    }

    @Deprecated(forRemoval=true)
    public CraterCommand executes(Consumer<BridgedCommandSourceStack> ctx) {
        return this.execute(stack -> {
            ctx.accept((BridgedCommandSourceStack)stack);
            return 1;
        });
    }

    @Deprecated(forRemoval=true)
    public CraterCommand withGameProfileArgument(String key, TriConsumer<BridgedPlayer, List<BridgedGameProfile>, BridgedCommandSourceStack> executor) {
        return this.withGameProfilesArgument(key, (player, argument, stack) -> {
            executor.accept(player, (List<BridgedGameProfile>)argument, stack);
            return 1;
        });
    }

    @ApiStatus.Internal
    public void register(CommandDispatcher<class_2168> stack) {
        stack.register(this.mojangCommand);
    }

    private boolean checkPermission(class_2168 stack) {
        try {
            if (!ModloaderEnvironment.INSTANCE.isModLoaded("luckperms") || ModloaderEnvironment.INSTANCE.getLoaderType() == LoaderType.PAPER || !(stack.method_9228() instanceof class_1657) || this.luckPermNode.isEmpty()) {
                return stack.method_9259(this.permLevel);
            }
        }
        catch (Exception e) {
            CraterConstants.LOG.error("Failed to check luckperms permissions", (Throwable)e);
            return stack.method_9259(this.permLevel);
        }
        return LuckPermsCompat.INSTANCE.hasPermission((class_3222)stack.method_9228(), this.luckPermNode) || stack.method_9259(this.permLevel);
    }

    @FunctionalInterface
    public static interface CommandExecutorWithArgs<S> {
        public int run(BridgedPlayer var1, S var2, BridgedCommandSourceStack var3);
    }

    @FunctionalInterface
    public static interface SingleCommandExecutor<S> {
        public int run(S var1);
    }
}

