/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.utils;

import com.hypherionmc.craterlib.nojang.resources.ResourceIdentifier;
import com.hypherionmc.craterlib.utils.DiscordMarkdownStripper;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import shadow.hypherionmc.mcdiscordformatter.discord.DiscordSerializer;
import shadow.hypherionmc.mcdiscordformatter.minecraft.MinecraftSerializer;
import shadow.kyori.adventure.text.Component;
import shadow.kyori.adventure.text.format.NamedTextColor;
import shadow.kyori.adventure.text.minimessage.MiniMessage;
import shadow.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import shadow.kyori.adventure.text.serializer.json.JSONOptions;

public class ChatUtils {
    private static final GsonComponentSerializer adventureSerializer = GsonComponentSerializer.builder().options(JSONOptions.byDataVersion().at(class_155.method_16673().method_37912().method_38494())).build();
    private static final MiniMessage miniMessage = MiniMessage.miniMessage();

    public static class_2561 adventureToMojang(Component inComponent) {
        String serialised = (String)adventureSerializer.serialize(inComponent);
        return class_2561.class_2562.method_10877((String)serialised);
    }

    public static Component mojangToAdventure(class_2561 inComponent) {
        try {
            String serialised = class_2561.class_2562.method_10867((class_2561)inComponent);
            return adventureSerializer.deserialize(serialised);
        }
        catch (Exception e) {
            return Component.text(inComponent.getString());
        }
    }

    public static class_2561 safeCopy(class_2561 inComponent) {
        String value = inComponent.getString();
        class_2583 style = inComponent.method_10866();
        return new class_2585(value).method_27696(style);
    }

    public static String strip(String inString, String ... toStrip) {
        String finalString = inString;
        for (String strip : toStrip) {
            if (finalString.startsWith(strip)) {
                finalString = finalString.replaceFirst(strip, "");
            }
            if (!finalString.startsWith(" ")) continue;
            finalString = finalString.replaceFirst(" ", "");
        }
        return finalString;
    }

    public static String resolve(Component component, boolean formatted) {
        class_2561 c = ChatUtils.adventureToMojang(component);
        String returnVal = class_124.method_539((String)DiscordMarkdownStripper.stripMarkdown(c.getString()));
        if (formatted) {
            returnVal = DiscordSerializer.INSTANCE.serialize(ChatUtils.safeCopy(c).method_27661());
        }
        return returnVal;
    }

    public static Component resolve(String component, boolean formatted) {
        class_2585 returnVal = new class_2585(component);
        if (formatted) {
            returnVal = MinecraftSerializer.INSTANCE.serialize(component);
        }
        return ChatUtils.mojangToAdventure((class_2561)returnVal);
    }

    public static Component getTooltipTitle(String key) {
        return Component.text(NamedTextColor.YELLOW + Component.translatable(key).key());
    }

    public static String resolveTranslation(String key) {
        return Component.translatable(key).key();
    }

    public static Component getTranslation(String key) {
        return Component.translatable(key);
    }

    public static Component makeComponent(String text) {
        return Component.translatable(text);
    }

    public static Component getBiomeName(ResourceIdentifier identifier) {
        if (identifier == null) {
            return Component.text("Unknown");
        }
        return ChatUtils.mojangToAdventure((class_2561)new class_2588(class_156.method_646((String)"biome", (class_2960)identifier.toMojang())));
    }

    public static Component format(String value) {
        value = ChatUtils.convertFormattingCodes(value);
        try {
            return miniMessage.deserializeOr(value, Component.translatable(value));
        }
        catch (Exception exception) {
            return Component.translatable(value);
        }
    }

    private static String convertFormattingCodes(String input) {
        return input.replaceAll("\u00a7([0-9a-fklmnor])", "\u00a7$1");
    }

    public static GsonComponentSerializer getAdventureSerializer() {
        return adventureSerializer;
    }
}

