/*
 * Decompiled with CFR 0.152.
 */
package shadow.hypherionmc.mcdiscordformatter.renderer;

import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shadow.hypherionmc.mcdiscordformatter.minecraft.MinecraftSerializerOptions;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.TextStyle;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.node.Node;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.node.StyleNode;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.node.TextNode;
import shadow.hypherionmc.mcdiscordformatter.renderer.MinecraftNodeRenderer;
import shadow.hypherionmc.mcdiscordformatter.rules.DiscordMarkdownRules;

public interface MinecraftRenderer
extends MinecraftNodeRenderer {
    @Override
    default public class_5250 render(class_5250 MutableComponent, Node<Object> node, MinecraftSerializerOptions<class_5250> serializerOptions, Function<Node<Object>, class_5250> renderWithChildren) {
        if (node instanceof TextNode) {
            MutableComponent = new class_2585(((TextNode)node).getContent());
        } else if (node instanceof StyleNode) {
            ArrayList styles = new ArrayList(((StyleNode)node).getStyles());
            for (TextStyle style : styles) {
                switch (style.getType()) {
                    case STRIKETHROUGH: {
                        MutableComponent = this.strikethrough(MutableComponent);
                        break;
                    }
                    case UNDERLINE: {
                        MutableComponent = this.underline(MutableComponent);
                        break;
                    }
                    case ITALICS: {
                        MutableComponent = this.italics(MutableComponent);
                        break;
                    }
                    case BOLD: {
                        MutableComponent = this.bold(MutableComponent);
                        break;
                    }
                    case CODE_STRING: {
                        MutableComponent = this.codeString(MutableComponent);
                        ((StyleNode)node).getStyles().remove(style);
                        break;
                    }
                    case CODE_BLOCK: {
                        MutableComponent = this.codeBlock(MutableComponent);
                        ((StyleNode)node).getStyles().remove(style);
                        break;
                    }
                    case QUOTE: {
                        class_2585 content = new class_2585("");
                        for (Node<Object> objectNode : serializerOptions.getParser().parse(style.getExtra().get("content"), new DiscordMarkdownRules.QuoteState(true), serializerOptions.getRules(), serializerOptions.isDebuggingEnabled())) {
                            content = content.method_10852((class_2561)renderWithChildren.apply(objectNode));
                        }
                        MutableComponent = this.appendQuote(MutableComponent, (class_5250)content);
                        break;
                    }
                    case SPOILER: {
                        class_2585 content = new class_2585("");
                        for (Node<Object> objectNode : serializerOptions.getParser().parse(style.getExtra().get("content"), null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled())) {
                            content = content.method_10852((class_2561)renderWithChildren.apply(objectNode));
                        }
                        MutableComponent = this.appendSpoiler(MutableComponent, (class_5250)content);
                        break;
                    }
                    case MENTION_EMOJI: {
                        MutableComponent = this.appendEmoteMention(MutableComponent, style.getExtra().get("name"), style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_CHANNEL: {
                        MutableComponent = this.appendChannelMention(MutableComponent, style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_USER: {
                        MutableComponent = this.appendUserMention(MutableComponent, style.getExtra().get("id"));
                        break;
                    }
                    case MENTION_ROLE: {
                        MutableComponent = this.appendRoleMention(MutableComponent, style.getExtra().get("id"));
                        break;
                    }
                }
            }
        }
        return MutableComponent;
    }

    @Nullable
    public class_5250 strikethrough(@NotNull class_5250 var1);

    @Nullable
    public class_5250 underline(@NotNull class_5250 var1);

    @Nullable
    public class_5250 italics(@NotNull class_5250 var1);

    @Nullable
    public class_5250 bold(@NotNull class_5250 var1);

    @Nullable
    public class_5250 codeString(@NotNull class_5250 var1);

    @Nullable
    public class_5250 codeBlock(@NotNull class_5250 var1);

    @Nullable
    public class_5250 appendSpoiler(@NotNull class_5250 var1, @NotNull class_5250 var2);

    @Nullable
    public class_5250 appendQuote(@NotNull class_5250 var1, @NotNull class_5250 var2);

    @Nullable
    public class_5250 appendEmoteMention(@NotNull class_5250 var1, @NotNull String var2, @NotNull String var3);

    @Nullable
    public class_5250 appendChannelMention(@NotNull class_5250 var1, @NotNull String var2);

    @Nullable
    public class_5250 appendUserMention(@NotNull class_5250 var1, @NotNull String var2);

    @Nullable
    public class_5250 appendRoleMention(@NotNull class_5250 var1, @NotNull String var2);
}

