/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.compat;

import com.google.auto.service.AutoService;
import com.hypherionmc.craterlib.compat.playerroles.PlayerRolesCompat;
import com.hypherionmc.craterlib.core.platform.CommonPlatform;
import com.hypherionmc.craterlib.core.platform.ModloaderEnvironment;
import com.hypherionmc.craterlib.nojang.authlib.BridgedGameProfile;
import dev.gegy.roles.SimpleRole;
import dev.gegy.roles.api.Role;
import dev.gegy.roles.config.PlayerRolesConfig;
import dev.gegy.roles.store.PlayerRoleManager;
import dev.gegy.roles.store.PlayerRoleSet;
import java.util.List;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.Nullable;

@AutoService(value={PlayerRolesCompat.class})
public class PlayerRolesCompatImpl
implements PlayerRolesCompat {
    @Override
    public void addRole(BridgedGameProfile profile, String roleName) {
        if (this.isNotLoaded()) {
            return;
        }
        this.updateRoles(PlayerRoleSet::add, profile, roleName);
    }

    @Override
    public void removeRole(BridgedGameProfile profile, String roleName) {
        if (this.isNotLoaded()) {
            return;
        }
        this.updateRoles(PlayerRoleSet::remove, profile, roleName);
    }

    @Override
    public boolean hasRole(BridgedGameProfile profile, String roleName) {
        if (this.isNotLoaded()) {
            return false;
        }
        return this.getRoles(profile).contains(roleName);
    }

    @Override
    public List<String> getRoles(BridgedGameProfile profile) {
        if (this.isNotLoaded()) {
            return List.of();
        }
        PlayerRoleManager manager = PlayerRoleManager.get();
        List roles = manager.peekRoles(CommonPlatform.INSTANCE.getMCServer().toMojang(), profile.getId()).stream().toList();
        return roles.stream().map(Role::getId).toList();
    }

    private boolean isNotLoaded() {
        return !ModloaderEnvironment.INSTANCE.isModLoaded("player_roles");
    }

    private void updateRoles(BiPredicate<PlayerRoleSet, SimpleRole> apply, BridgedGameProfile profile, String roleName) {
        PlayerRoleManager manager = PlayerRoleManager.get();
        SimpleRole role = this.getRoleInternal(roleName);
        if (role == null) {
            return;
        }
        manager.updateRoles(CommonPlatform.INSTANCE.getMCServer().toMojang(), profile.getId(), roles -> apply.test((PlayerRoleSet)roles, role));
    }

    @Nullable
    private SimpleRole getRoleInternal(String roleName) {
        return PlayerRolesConfig.get().get(roleName);
    }
}

