/*
 * Decompiled with CFR 0.152.
 */
package shadow.hypherionmc.mcdiscordformatter.discord;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2572;
import net.minecraft.class_2578;
import net.minecraft.class_2579;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import shadow.hypherionmc.mcdiscordformatter.discord.DiscordSerializerOptions;
import shadow.hypherionmc.mcdiscordformatter.text.Text;

public class DiscordSerializer {
    public static final DiscordSerializer INSTANCE = new DiscordSerializer(){

        @Override
        public void setDefaultOptions(DiscordSerializerOptions defaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }

        @Override
        @Deprecated
        public void setKeybindProvider(Function<class_2572, String> provider) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }

        @Override
        @Deprecated
        public void setTranslationProvider(Function<class_5250, String> provider) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }
    };
    private DiscordSerializerOptions defaultOptions;
    private Function<class_2572, String> keybindProvider;
    private Function<class_5250, String> translationProvider;

    public DiscordSerializer() {
        this(DiscordSerializerOptions.defaults());
    }

    public DiscordSerializer(@NotNull DiscordSerializerOptions defaultOptions) {
        this.defaultOptions = defaultOptions;
        this.translationProvider = defaultOptions.getTranslationProvider();
        this.keybindProvider = defaultOptions.getKeybindProvider();
    }

    @Deprecated
    public Function<class_2572, String> getKeybindProvider() {
        return this.keybindProvider;
    }

    @Deprecated
    public void setKeybindProvider(Function<class_2572, String> provider) {
        this.keybindProvider = provider;
    }

    @Deprecated
    public Function<class_5250, String> getTranslationProvider() {
        return this.translationProvider;
    }

    @Deprecated
    public void setTranslationProvider(Function<class_5250, String> provider) {
        this.translationProvider = provider;
    }

    public String serialize(@NotNull class_5250 component) {
        DiscordSerializerOptions options = this.getDefaultOptions();
        if (this.keybindProvider != null) {
            options = options.withKeybindProvider(this.keybindProvider);
        }
        if (this.translationProvider != null) {
            options = options.withTranslationProvider(this.translationProvider);
        }
        return this.serialize(component, options);
    }

    @Deprecated
    public String serialize(@NotNull class_5250 component, boolean embedLinks) {
        return this.serialize(component, this.defaultOptions.withEmbedLinks(embedLinks));
    }

    public String serialize(@NotNull class_5250 component, @NotNull DiscordSerializerOptions serializerOptions) {
        StringBuilder stringBuilder = new StringBuilder();
        LinkedList<Text> texts = this.getTexts(new LinkedList<Text>(), component, new Text(), serializerOptions);
        for (Text text : texts) {
            String content = text.getContent();
            if (content.isEmpty()) continue;
            if (text.isBold()) {
                stringBuilder.append("**");
            }
            if (text.isStrikethrough()) {
                stringBuilder.append("~~");
            }
            if (text.isItalic()) {
                stringBuilder.append("_");
            }
            if (text.isUnderline()) {
                stringBuilder.append("__");
            }
            if (serializerOptions.isEscapeMarkdown()) {
                content = content.replace("(?<!\\\\)(?:\\\\\\\\)*\\*", "\\*").replace("(?<!\\\\)(?:\\\\\\\\)*~", "\\~").replace("(?<!\\\\)(?:\\\\\\\\)*_", "\\_").replace("(?<!\\\\)(?:\\\\\\\\)*`", "\\`").replace("(?<!\\\\)(?:\\\\\\\\)*\\|", "\\|");
            }
            stringBuilder.append(class_124.method_539((String)content));
            if (text.isUnderline()) {
                stringBuilder.append("__");
            }
            if (text.isItalic()) {
                stringBuilder.append("_");
            }
            if (text.isStrikethrough()) {
                stringBuilder.append("~~");
            }
            if (text.isBold()) {
                stringBuilder.append("**");
            }
            stringBuilder.append("\u200b");
        }
        int length = stringBuilder.length();
        return length < 1 ? "" : stringBuilder.substring(0, length - 1);
    }

    private LinkedList<Text> getTexts(@NotNull List<Text> input, @NotNull class_5250 component, @NotNull Text text, @NotNull DiscordSerializerOptions serializerOptions) {
        Text previous;
        String content;
        LinkedList<Text> output = new LinkedList<Text>(input);
        if (component.method_10851() instanceof class_2572) {
            class_2572 keybindComponent = (class_2572)component.method_10851();
            content = this.keybindProvider.apply(keybindComponent);
        } else if (component.method_10851() instanceof class_2578) {
            class_2578 scoreText = (class_2578)component.method_10851();
            content = scoreText.method_10928();
        } else if (component.method_10851() instanceof class_2579) {
            class_2579 selectorText = (class_2579)component.method_10851();
            content = selectorText.method_10932();
        } else {
            content = component.method_10851() instanceof class_2585 ? component.getString() : (component.method_10851() instanceof class_2588 ? this.translationProvider.apply(component) : "");
        }
        class_2558 clickEvent = component.method_10866().method_10970();
        if (serializerOptions.isEmbedLinks() && clickEvent != null && clickEvent.method_10845() == class_2558.class_2559.field_11749) {
            text.setContent("[" + content + "](" + clickEvent.method_10844() + ")");
        } else {
            text.setContent(content);
        }
        if (component.method_10866().method_10984()) {
            text.setBold(true);
        }
        text.setBold(component.method_10866().method_10984());
        text.setItalic(component.method_10866().method_10966());
        text.setUnderline(component.method_10866().method_10965());
        text.setStrikethrough(component.method_10866().method_10986());
        if (!output.isEmpty() && text.formattingMatches(previous = output.getLast())) {
            output.removeLast();
            text.setContent(previous.getContent() + text.getContent());
        }
        output.add(text);
        for (class_2561 child : component.method_10855()) {
            Text next = text.clone();
            next.setContent("");
            output = this.getTexts(output, (class_5250)child, next, serializerOptions);
        }
        return output;
    }

    public DiscordSerializerOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setDefaultOptions(DiscordSerializerOptions defaultOptions) {
        this.defaultOptions = defaultOptions;
    }
}

