/*
 * Decompiled with CFR 0.152.
 */
package shadow.hypherionmc.mcdiscordformatter.discord;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.KeybindComponent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.ScoreComponent;
import net.minecraft.network.chat.SelectorComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.NotNull;
import shadow.hypherionmc.mcdiscordformatter.discord.DiscordSerializerOptions;
import shadow.hypherionmc.mcdiscordformatter.text.Text;

public class DiscordSerializer {
    public static final DiscordSerializer INSTANCE = new DiscordSerializer(){

        @Override
        public void setDefaultOptions(DiscordSerializerOptions defaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }

        @Override
        @Deprecated
        public void setKeybindProvider(Function<KeybindComponent, String> provider) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }

        @Override
        @Deprecated
        public void setTranslationProvider(Function<TranslatableComponent, String> provider) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }
    };
    private DiscordSerializerOptions defaultOptions;
    private Function<KeybindComponent, String> keybindProvider;
    private Function<TranslatableComponent, String> translationProvider;

    public DiscordSerializer() {
        this(DiscordSerializerOptions.defaults());
    }

    public DiscordSerializer(@NotNull DiscordSerializerOptions defaultOptions) {
        this.defaultOptions = defaultOptions;
        this.translationProvider = defaultOptions.getTranslationProvider();
        this.keybindProvider = defaultOptions.getKeybindProvider();
    }

    @Deprecated
    public Function<KeybindComponent, String> getKeybindProvider() {
        return this.keybindProvider;
    }

    @Deprecated
    public void setKeybindProvider(Function<KeybindComponent, String> provider) {
        this.keybindProvider = provider;
    }

    @Deprecated
    public Function<TranslatableComponent, String> getTranslationProvider() {
        return this.translationProvider;
    }

    @Deprecated
    public void setTranslationProvider(Function<TranslatableComponent, String> provider) {
        this.translationProvider = provider;
    }

    public String serialize(@NotNull MutableComponent component) {
        DiscordSerializerOptions options = this.getDefaultOptions();
        if (this.keybindProvider != null) {
            options = options.withKeybindProvider(this.keybindProvider);
        }
        if (this.translationProvider != null) {
            options = options.withTranslationProvider(this.translationProvider);
        }
        return this.serialize(component, options);
    }

    @Deprecated
    public String serialize(@NotNull MutableComponent component, boolean embedLinks) {
        return this.serialize(component, this.defaultOptions.withEmbedLinks(embedLinks));
    }

    public String serialize(@NotNull MutableComponent component, @NotNull DiscordSerializerOptions serializerOptions) {
        StringBuilder stringBuilder = new StringBuilder();
        LinkedList<Text> texts = this.getTexts(new LinkedList<Text>(), component, new Text(), serializerOptions);
        for (Text text : texts) {
            String content = text.getContent();
            if (content.isEmpty()) continue;
            if (text.isBold()) {
                stringBuilder.append("**");
            }
            if (text.isStrikethrough()) {
                stringBuilder.append("~~");
            }
            if (text.isItalic()) {
                stringBuilder.append("_");
            }
            if (text.isUnderline()) {
                stringBuilder.append("__");
            }
            if (serializerOptions.isEscapeMarkdown()) {
                content = content.replace("(?<!\\\\)(?:\\\\\\\\)*\\*", "\\*").replace("(?<!\\\\)(?:\\\\\\\\)*~", "\\~").replace("(?<!\\\\)(?:\\\\\\\\)*_", "\\_").replace("(?<!\\\\)(?:\\\\\\\\)*`", "\\`").replace("(?<!\\\\)(?:\\\\\\\\)*\\|", "\\|");
            }
            stringBuilder.append(ChatFormatting.m_126649_((String)content));
            if (text.isUnderline()) {
                stringBuilder.append("__");
            }
            if (text.isItalic()) {
                stringBuilder.append("_");
            }
            if (text.isStrikethrough()) {
                stringBuilder.append("~~");
            }
            if (text.isBold()) {
                stringBuilder.append("**");
            }
            stringBuilder.append("\u200b");
        }
        int length = stringBuilder.length();
        return length < 1 ? "" : stringBuilder.substring(0, length - 1);
    }

    private LinkedList<Text> getTexts(@NotNull List<Text> input, @NotNull MutableComponent component, @NotNull Text text, @NotNull DiscordSerializerOptions serializerOptions) {
        Text previous;
        String content;
        LinkedList<Text> output = new LinkedList<Text>(input);
        if (component instanceof KeybindComponent) {
            KeybindComponent keybindComponent = (KeybindComponent)component;
            content = this.keybindProvider.apply(keybindComponent);
        } else if (component instanceof ScoreComponent) {
            ScoreComponent scoreText = (ScoreComponent)component;
            content = scoreText.m_131072_();
        } else if (component instanceof SelectorComponent) {
            SelectorComponent selectorText = (SelectorComponent)component;
            content = selectorText.m_131096_();
        } else if (component instanceof TextComponent) {
            content = component.getString();
        } else if (component instanceof TranslatableComponent) {
            TranslatableComponent translatableComponent = (TranslatableComponent)component;
            content = this.translationProvider.apply(translatableComponent);
        } else {
            content = "";
        }
        ClickEvent clickEvent = component.m_7383_().m_131182_();
        if (serializerOptions.isEmbedLinks() && clickEvent != null && clickEvent.m_130622_() == ClickEvent.Action.OPEN_URL) {
            text.setContent("[" + content + "](" + clickEvent.m_130623_() + ")");
        } else {
            text.setContent(content);
        }
        if (component.m_7383_().m_131154_()) {
            text.setBold(true);
        }
        text.setBold(component.m_7383_().m_131154_());
        text.setItalic(component.m_7383_().m_131161_());
        text.setUnderline(component.m_7383_().m_131171_());
        text.setStrikethrough(component.m_7383_().m_131168_());
        if (!output.isEmpty() && text.formattingMatches(previous = output.getLast())) {
            output.removeLast();
            text.setContent(previous.getContent() + text.getContent());
        }
        output.add(text);
        for (Component child : component.m_7360_()) {
            Text next = text.clone();
            next.setContent("");
            output = this.getTexts(output, (MutableComponent)child, next, serializerOptions);
        }
        return output;
    }

    public DiscordSerializerOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public void setDefaultOptions(DiscordSerializerOptions defaultOptions) {
        this.defaultOptions = defaultOptions;
    }
}

