/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.mixin.events;

import com.hypherionmc.craterlib.api.events.server.CraterPlayerEvent;
import com.hypherionmc.craterlib.api.events.server.MessageBroadcastEvent;
import com.hypherionmc.craterlib.api.events.server.PlayerPreLoginEvent;
import com.hypherionmc.craterlib.core.event.CraterEventBus;
import com.hypherionmc.craterlib.nojang.authlib.BridgedGameProfile;
import com.hypherionmc.craterlib.nojang.world.entity.player.BridgedPlayer;
import com.hypherionmc.craterlib.utils.ChatUtils;
import java.net.SocketAddress;
import java.util.function.Function;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerList.class})
public class PlayerListMixin {
    @Inject(method={"broadcastSystemMessage(Lnet/minecraft/network/chat/Component;Ljava/util/function/Function;Z)V"}, at={@At(value="HEAD")})
    private void injectBroadcastEvent(Component component, Function<ServerPlayer, Component> function, boolean bl, CallbackInfo ci) {
        String thread = Thread.currentThread().getStackTrace()[3].getClassName();
        MessageBroadcastEvent event = new MessageBroadcastEvent(ChatUtils.mojangToAdventure(component), f -> ChatUtils.mojangToAdventure(component), bl, thread);
        CraterEventBus.INSTANCE.postEvent(event);
    }

    @Inject(method={"placeNewPlayer"}, at={@At(value="TAIL")})
    private void injectPlayerLoginEvent(Connection connection, ServerPlayer serverPlayer, CommonListenerCookie commonListenerCookie, CallbackInfo ci) {
        CraterEventBus.INSTANCE.postEvent(new CraterPlayerEvent.PlayerLoggedIn(BridgedPlayer.of((Player)serverPlayer)));
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    private void injectPlayerLogoutEvent(ServerPlayer player, CallbackInfo ci) {
        CraterEventBus.INSTANCE.postEvent(new CraterPlayerEvent.PlayerLoggedOut(BridgedPlayer.of((Player)player)));
    }

    @Inject(method={"canPlayerLogin"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectPreLoginEvent(SocketAddress socketAddress, NameAndId arg, CallbackInfoReturnable<Component> cir) {
        PlayerPreLoginEvent event = new PlayerPreLoginEvent(socketAddress, BridgedGameProfile.of(arg));
        CraterEventBus.INSTANCE.postEvent(event);
        if (event.getMessage() != null) {
            cir.setReturnValue((Object)ChatUtils.adventureToMojang(event.getMessage()));
        }
    }
}

