/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.nojang.client.multiplayer;

import com.hypherionmc.craterlib.nojang.core.BridgedBlockPos;
import com.hypherionmc.craterlib.nojang.resources.ResourceIdentifier;
import com.hypherionmc.craterlib.utils.ChatUtils;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.multiplayer.ClientLevel;
import org.jetbrains.annotations.Nullable;
import shadow.kyori.adventure.text.Component;

public class BridgedClientLevel {
    private final ClientLevel internal;

    public boolean isClientSide() {
        return this.internal.isClientSide();
    }

    public long getGameTime() {
        return this.internal.getGameTime();
    }

    public long getDayTime() {
        return this.internal.getDayTime();
    }

    public long dayTime() {
        return this.internal.dayTime();
    }

    public boolean isRaining() {
        return this.internal.isRaining();
    }

    public boolean isThundering() {
        return this.internal.isThundering();
    }

    @Nullable
    public ResourceIdentifier getDimensionKey() {
        return ResourceIdentifier.fromMojang(this.internal.dimension().location());
    }

    @Nullable
    public ResourceIdentifier getBiomeIdentifier(BridgedBlockPos onPos) {
        AtomicReference<Object> identifier = new AtomicReference<Object>(null);
        this.internal.getBiome(onPos.toMojang()).unwrap().ifLeft(b -> identifier.set(ResourceIdentifier.fromMojang(b.location())));
        return identifier.get();
    }

    @Nullable
    public Component getDifficulty() {
        return ChatUtils.mojangToAdventure(this.internal.getDifficulty().getDisplayName());
    }

    private BridgedClientLevel(ClientLevel internal) {
        this.internal = internal;
    }

    public static BridgedClientLevel of(ClientLevel internal) {
        return new BridgedClientLevel(internal);
    }
}

