/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.network;

import com.hypherionmc.craterlib.CraterConstants;
import com.hypherionmc.craterlib.api.networking.CommonPacketWrapper;
import com.hypherionmc.craterlib.core.networking.PacketRegistry;
import com.hypherionmc.craterlib.core.networking.data.PacketContext;
import com.hypherionmc.craterlib.core.networking.data.PacketHolder;
import com.hypherionmc.craterlib.core.networking.data.PacketSide;
import com.hypherionmc.craterlib.nojang.world.entity.player.BridgedPlayer;
import java.util.function.Consumer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public class CraterNeoForgeNetworkHandler
extends PacketRegistry {
    public CraterNeoForgeNetworkHandler(PacketSide side) {
        super(side);
    }

    @SubscribeEvent
    public void register(RegisterPayloadHandlersEvent event) {
        if (!this.PACKET_MAP.isEmpty()) {
            this.PACKET_MAP.forEach((type, container) -> event.registrar(container.getType().id().getNamespace()).optional().commonBidirectional(container.getType(), container.getCodec(), this.buildHandler(container.handler())));
        }
    }

    @Override
    protected <T> void registerPacket(PacketHolder<T> container) {
    }

    @Override
    public <T> void sendToServer(T packet) {
        this.sendToServer(packet, false);
    }

    @Override
    public <T> void sendToServer(T packet, boolean ignoreCheck) {
        PacketHolder container = (PacketHolder)this.PACKET_MAP.get(packet.getClass());
        if (container != null) {
            ClientPacketDistributor.sendToServer(new CommonPacketWrapper<T>(container, packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public <T> void sendToClient(T packet, BridgedPlayer player) {
        PacketHolder container = (PacketHolder)this.PACKET_MAP.get(packet.getClass());
        if (container != null && player.getConnection().hasChannel(container.type())) {
            PacketDistributor.sendToPlayer((ServerPlayer)player.toMojangServerPlayer(), new CommonPacketWrapper<T>(container, packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private <T, K extends CommonPacketWrapper<T>> IPayloadHandler<K> buildHandler(Consumer<PacketContext<T>> handler) {
        return (payload, ctx) -> {
            try {
                PacketSide side;
                PacketSide packetSide = side = ctx.flow().getReceptionSide().equals((Object)LogicalSide.SERVER) ? PacketSide.SERVER : PacketSide.CLIENT;
                if (PacketSide.SERVER.equals((Object)side)) {
                    handler.accept(new PacketContext(BridgedPlayer.of(ctx.player()), payload.packet(), side));
                } else {
                    handler.accept(new PacketContext(payload.packet(), side));
                }
            }
            catch (Throwable t) {
                CraterConstants.LOG.error("Error handling packet: {} -> ", payload.packet().getClass(), (Object)t);
            }
        };
    }
}

