/*
 * Decompiled with CFR 0.152.
 */
package shadow.hypherionmc.mcdiscordformatter.renderer.implementation;

import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import shadow.hypherionmc.mcdiscordformatter.renderer.MinecraftRenderer;

public class DefaultMinecraftRenderer
implements MinecraftRenderer {
    public static final DefaultMinecraftRenderer INSTANCE = new DefaultMinecraftRenderer();
    private static final Pattern PATTERN_NEWLINE = Pattern.compile("\n");

    @Override
    public MutableComponent strikethrough(MutableComponent component) {
        return component.withStyle(ChatFormatting.STRIKETHROUGH);
    }

    @Override
    public MutableComponent underline(MutableComponent component) {
        return component.withStyle(ChatFormatting.UNDERLINE);
    }

    @Override
    public MutableComponent italics(MutableComponent component) {
        return component.withStyle(ChatFormatting.ITALIC);
    }

    @Override
    public MutableComponent bold(MutableComponent component) {
        return component.withStyle(ChatFormatting.BOLD);
    }

    @Override
    public MutableComponent codeString(MutableComponent component) {
        return component.withStyle(ChatFormatting.DARK_GRAY);
    }

    @Override
    public MutableComponent codeBlock(MutableComponent component) {
        return component.withStyle(ChatFormatting.DARK_GRAY);
    }

    @Override
    public MutableComponent appendSpoiler(MutableComponent component, MutableComponent content) {
        return component.append((Component)Component.literal((String)"\u258c".repeat(content.getString().length())).withStyle(style -> style.withColor(ChatFormatting.DARK_GRAY).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)content))));
    }

    @Override
    public MutableComponent appendQuote(MutableComponent component, MutableComponent content) {
        MutableComponent prefix = Component.literal((String)"| ").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.BOLD});
        return Component.empty().append((Component)prefix).append((Component)component);
    }

    @Override
    public MutableComponent appendEmoteMention(MutableComponent component, String name, String id) {
        return component.append((Component)Component.literal((String)(":" + name + ":")));
    }

    @Override
    public MutableComponent appendChannelMention(MutableComponent component, String id) {
        return component.append((Component)Component.literal((String)("<#" + id + ">")));
    }

    @Override
    public MutableComponent appendUserMention(MutableComponent component, String id) {
        return component.append((Component)Component.literal((String)("<@" + id + ">")));
    }

    @Override
    public MutableComponent appendRoleMention(MutableComponent component, String id) {
        return component.append((Component)Component.literal((String)("<@&" + id + ">")));
    }
}

