/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.client.gui.config;

import com.hypherionmc.craterlib.CraterConstants;
import com.hypherionmc.craterlib.client.gui.config.widgets.ClothConfigButtonEntry;
import com.hypherionmc.craterlib.core.config.AbstractConfig;
import com.hypherionmc.craterlib.core.config.annotations.HideFromScreen;
import com.hypherionmc.craterlib.core.config.annotations.SubConfig;
import com.hypherionmc.craterlib.core.config.annotations.Tooltip;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.DoubleFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.FloatFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.LongFieldBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import shadow.hypherionmc.moonconfig.core.conversion.SpecComment;

@ApiStatus.Internal
public class ClothConfigScreenBuilder {
    public static class_437 buildConfigScreen(AbstractConfig config, @Nullable class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle(ClothConfigScreenBuilder.getTranslationKey(config, config, null));
        ClothConfigScreenBuilder.readConfigFields(config, config, builder);
        builder.setSavingRunnable(() -> ClothConfigScreenBuilder.safeSaveConfig(config));
        return builder.build();
    }

    private static class_437 buildSubScreen(AbstractConfig config, Object clazz, @Nullable class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle(ClothConfigScreenBuilder.getTranslationKey(config, clazz, null));
        ClothConfigScreenBuilder.readConfigFields(config, clazz, builder);
        builder.setSavingRunnable(() -> ClothConfigScreenBuilder.safeSaveConfig(config));
        return builder.build();
    }

    private static class_437 buildListScreen(AbstractConfig config, List list, Field field, Object invoker, @Nullable class_437 parent, boolean edited) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle(ClothConfigScreenBuilder.getTranslationKey(config, invoker, field.getName()));
        ConfigCategory category = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Entries"));
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            int finalI = i;
            category.addEntry((AbstractConfigListEntry)new ClothConfigButtonEntry((class_2561)class_2561.method_43469((String)"cl.buttons.entry", (Object[])new Object[]{i + 1}), (class_2561)class_2561.method_43471((String)"cl.buttons.edit"), button -> class_310.method_1551().method_1507(ClothConfigScreenBuilder.buildSubScreen(config, item, builder.build())), button -> {
                list.remove(finalI);
                ClothConfigScreenBuilder.saveFieldValue(list, field, invoker);
                class_310.method_1551().method_1507(ClothConfigScreenBuilder.buildListScreen(config, list, field, invoker, parent, true));
            }, edited));
        }
        Type listType = field.getGenericType();
        if (listType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)listType;
            Class elementType = (Class)paramType.getActualTypeArguments()[0];
            category.addEntry((AbstractConfigListEntry)new ClothConfigButtonEntry((class_2561)class_2561.method_43470((String)""), (class_2561)class_2561.method_43471((String)"cl.buttons.add_entry"), button -> {
                try {
                    Object newItem = elementType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    list.add(newItem);
                    ClothConfigScreenBuilder.saveFieldValue(list, field, invoker);
                    class_310.method_1551().method_1507(ClothConfigScreenBuilder.buildListScreen(config, list, field, invoker, parent, true));
                }
                catch (Exception e) {
                    CraterConstants.LOG.error("Failed to create new list entry", (Throwable)e);
                }
            }));
        }
        builder.setSavingRunnable(() -> ClothConfigScreenBuilder.safeSaveConfig(config));
        return builder.build();
    }

    private static void readConfigFields(AbstractConfig baseConfig, Object config, ConfigBuilder builder) {
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory configCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"General"));
        for (Field field : config.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                int fieldModifiers = field.getModifiers();
                if (Modifier.isStatic(fieldModifiers) || Modifier.isTransient(fieldModifiers) || field.isAnnotationPresent(HideFromScreen.class)) continue;
                Object val = field.get(config);
                if (field.isAnnotationPresent(SubConfig.class) && val != null) {
                    configCategory.addEntry((AbstractConfigListEntry)new ClothConfigButtonEntry((class_2561)class_2561.method_43471((String)("cl.config." + baseConfig.getClass().getSimpleName().toLowerCase() + "." + field.getName().toLowerCase())), (class_2561)class_2561.method_43471((String)"cl.buttons.edit"), button -> class_310.method_1551().method_1507(ClothConfigScreenBuilder.buildSubScreen(baseConfig, val, builder.build()))));
                    continue;
                }
                if (val instanceof Boolean) {
                    Boolean bool = (Boolean)val;
                    configCategory.addEntry((AbstractConfigListEntry)((BooleanToggleBuilder)entryBuilder.startBooleanToggle(ClothConfigScreenBuilder.getTranslationKey(baseConfig, config, field.getName()), bool.booleanValue()).setTooltip(new class_2561[]{ClothConfigScreenBuilder.getToolTip(field)}).setSaveConsumer(newValue -> ClothConfigScreenBuilder.saveFieldValue(newValue, field, config)).setDefaultValue((Object)bool)).build());
                }
                if (val instanceof Enum) {
                    Enum enumValue = (Enum)val;
                    Class enumClass = enumValue.getDeclaringClass();
                    configCategory.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector(ClothConfigScreenBuilder.getTranslationKey(baseConfig, config, field.getName()), enumClass, enumValue).setTooltip(new class_2561[]{ClothConfigScreenBuilder.getToolTip(field)}).setSaveConsumer(newValue -> ClothConfigScreenBuilder.saveFieldValue(newValue, field, config)).setDefaultValue(enumValue).build());
                }
                if (val instanceof Integer) {
                    Integer intt = (Integer)val;
                    configCategory.addEntry((AbstractConfigListEntry)((IntFieldBuilder)entryBuilder.startIntField(ClothConfigScreenBuilder.getTranslationKey(baseConfig, config, field.getName()), intt.intValue()).setTooltip(new class_2561[]{ClothConfigScreenBuilder.getToolTip(field)}).setSaveConsumer(newValue -> ClothConfigScreenBuilder.saveFieldValue(newValue, field, config)).setDefaultValue((Object)intt)).build());
                }
                if (val instanceof Long) {
                    Long longt = (Long)val;
                    configCategory.addEntry((AbstractConfigListEntry)((LongFieldBuilder)entryBuilder.startLongField(ClothConfigScreenBuilder.getTranslationKey(baseConfig, config, field.getName()), longt.longValue()).setTooltip(new class_2561[]{ClothConfigScreenBuilder.getToolTip(field)}).setSaveConsumer(newValue -> ClothConfigScreenBuilder.saveFieldValue(newValue, field, config)).setDefaultValue((Object)longt)).build());
                }
                if (val instanceof Float) {
                    Float floatt = (Float)val;
                    configCategory.addEntry((AbstractConfigListEntry)((FloatFieldBuilder)entryBuilder.startFloatField(ClothConfigScreenBuilder.getTranslationKey(baseConfig, config, field.getName()), floatt.floatValue()).setTooltip(new class_2561[]{ClothConfigScreenBuilder.getToolTip(field)}).setSaveConsumer(newValue -> ClothConfigScreenBuilder.saveFieldValue(newValue, field, config)).setDefaultValue((Object)floatt)).build());
                }
                if (val instanceof Double) {
                    Double doublet = (Double)val;
                    configCategory.addEntry((AbstractConfigListEntry)((DoubleFieldBuilder)entryBuilder.startDoubleField(ClothConfigScreenBuilder.getTranslationKey(baseConfig, config, field.getName()), doublet.doubleValue()).setTooltip(new class_2561[]{ClothConfigScreenBuilder.getToolTip(field)}).setSaveConsumer(newValue -> ClothConfigScreenBuilder.saveFieldValue(newValue, field, config)).setDefaultValue((Object)doublet)).build());
                }
                if (val instanceof String) {
                    String string = (String)val;
                    configCategory.addEntry((AbstractConfigListEntry)entryBuilder.startStrField(ClothConfigScreenBuilder.getTranslationKey(baseConfig, config, field.getName()), string).setTooltip(new class_2561[]{ClothConfigScreenBuilder.getToolTip(field)}).setSaveConsumer(newValue -> ClothConfigScreenBuilder.saveFieldValue(newValue, field, config)).setDefaultValue(string).build());
                }
                if (!(val instanceof List)) continue;
                List list = (List)val;
                Type listType = field.getGenericType();
                if (!(listType instanceof ParameterizedType)) continue;
                ParameterizedType paramType = (ParameterizedType)listType;
                Type elementType = paramType.getActualTypeArguments()[0];
                if (elementType.equals(String.class)) {
                    configCategory.addEntry((AbstractConfigListEntry)entryBuilder.startStrList(ClothConfigScreenBuilder.getTranslationKey(baseConfig, config, field.getName()), list).setTooltip(new class_2561[]{ClothConfigScreenBuilder.getToolTip(field)}).setSaveConsumer(newValue -> ClothConfigScreenBuilder.saveFieldValue(new ArrayList(newValue), field, config)).setDefaultValue(list).build());
                    continue;
                }
                if (elementType.equals(Integer.class)) {
                    configCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntList(ClothConfigScreenBuilder.getTranslationKey(baseConfig, config, field.getName()), list).setTooltip(new class_2561[]{ClothConfigScreenBuilder.getToolTip(field)}).setSaveConsumer(newValue -> ClothConfigScreenBuilder.saveFieldValue(new ArrayList(newValue), field, config)).setDefaultValue(list).build());
                    continue;
                }
                if (elementType.equals(Long.class)) {
                    configCategory.addEntry((AbstractConfigListEntry)entryBuilder.startLongList(ClothConfigScreenBuilder.getTranslationKey(baseConfig, config, field.getName()), list).setTooltip(new class_2561[]{ClothConfigScreenBuilder.getToolTip(field)}).setSaveConsumer(newValue -> ClothConfigScreenBuilder.saveFieldValue(new ArrayList(newValue), field, config)).setDefaultValue(list).build());
                    continue;
                }
                if (elementType.equals(Float.class)) {
                    configCategory.addEntry((AbstractConfigListEntry)entryBuilder.startFloatList(ClothConfigScreenBuilder.getTranslationKey(baseConfig, config, field.getName()), list).setTooltip(new class_2561[]{ClothConfigScreenBuilder.getToolTip(field)}).setSaveConsumer(newValue -> ClothConfigScreenBuilder.saveFieldValue(new ArrayList(newValue), field, config)).setDefaultValue(list).build());
                    continue;
                }
                if (elementType.equals(Double.class)) {
                    configCategory.addEntry((AbstractConfigListEntry)entryBuilder.startDoubleList(ClothConfigScreenBuilder.getTranslationKey(baseConfig, config, field.getName()), list).setTooltip(new class_2561[]{ClothConfigScreenBuilder.getToolTip(field)}).setSaveConsumer(newValue -> ClothConfigScreenBuilder.saveFieldValue(new ArrayList(newValue), field, config)).setDefaultValue(list).build());
                    continue;
                }
                configCategory.addEntry((AbstractConfigListEntry)new ClothConfigButtonEntry(ClothConfigScreenBuilder.getTranslationKey(baseConfig, config, field.getName()), (class_2561)class_2561.method_43471((String)"cl.buttons.edit"), button -> class_310.method_1551().method_1507(ClothConfigScreenBuilder.buildListScreen(baseConfig, list, field, config, builder.build(), false))));
            }
            catch (Exception e) {
                CraterConstants.LOG.error("Failed to process config file {}", (Object)baseConfig.getConfigName(), (Object)e);
            }
        }
    }

    private static class_2561 getToolTip(Field field) {
        class_5250 component = class_2561.method_43473();
        if (field.isAnnotationPresent(SpecComment.class)) {
            SpecComment comment = field.getAnnotation(SpecComment.class);
            component = class_2561.method_43470((String)comment.value());
        }
        if (field.isAnnotationPresent(Tooltip.class)) {
            Tooltip tooltip = field.getAnnotation(Tooltip.class);
            class_5250 c = class_2561.method_43473();
            for (String comment : tooltip.value()) {
                c.method_10855().add(class_2561.method_43470((String)comment));
            }
            component = c;
        }
        return component;
    }

    private static class_2561 getTranslationKey(AbstractConfig baseConfig, Object currentConfig, String fieldName) {
        String baseKey = "cl.config." + baseConfig.getClass().getSimpleName().toLowerCase();
        if (currentConfig != baseConfig) {
            baseKey = baseKey + "." + currentConfig.getClass().getSimpleName().toLowerCase();
        }
        if (fieldName != null) {
            baseKey = baseKey + "." + fieldName.toLowerCase();
        }
        return class_2561.method_43471((String)baseKey);
    }

    private static void saveFieldValue(Object value, Field field, Object config) {
        try {
            if (value instanceof List && !field.getType().equals(List.class)) {
                List newList = (List)field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                newList.addAll((List)value);
                field.set(config, newList);
            } else {
                field.set(config, value);
            }
        }
        catch (Exception e) {
            CraterConstants.LOG.error("Failed to write config field {}", (Object)field.getName(), (Object)e);
        }
    }

    private static void safeSaveConfig(AbstractConfig config) {
        File configPath = config.getConfigPath();
        Path backupPath = configPath.toPath().resolveSibling(configPath.getName() + ".bak");
        try {
            Files.copy(configPath.toPath(), backupPath, StandardCopyOption.REPLACE_EXISTING);
            config.saveConfig(config);
            Files.deleteIfExists(backupPath);
        }
        catch (Exception e) {
            class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47585, (class_2561)class_2561.method_43470((String)"Failed To Save Config"), (class_2561)class_2561.method_43470((String)"Restoring Backup Copy. Check log for details")));
            CraterConstants.LOG.error("Failed to save config, restoring backup", (Throwable)e);
            try {
                Files.copy(backupPath, configPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
                config.configReloaded();
            }
            catch (Exception restoreError) {
                CraterConstants.LOG.error("Failed to restore config backup", (Throwable)restoreError);
            }
        }
    }
}

