/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.client.gui.config;

import com.hypherionmc.craterlib.CraterConstants;
import com.hypherionmc.craterlib.client.gui.config.widgets.InternalConfigButton;
import com.hypherionmc.craterlib.client.gui.config.widgets.Option;
import com.hypherionmc.craterlib.client.gui.config.widgets.SubConfigWidget;
import com.hypherionmc.craterlib.client.gui.config.widgets.TextConfigOption;
import com.hypherionmc.craterlib.client.gui.config.widgets.ToggleButton;
import com.hypherionmc.craterlib.core.config.AbstractConfig;
import com.hypherionmc.craterlib.core.config.annotations.HideFromScreen;
import com.hypherionmc.craterlib.core.config.annotations.SubConfig;
import com.hypherionmc.craterlib.core.config.annotations.Tooltip;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import shadow.hypherionmc.moonconfig.core.conversion.SpecComment;

@Deprecated(forRemoval=true, since="2.1.3")
public class CraterConfigScreen
extends Screen {
    public static final float SCROLLBAR_BOTTOM_COLOR = 0.5f;
    public static final float SCROLLBAR_TOP_COLOR = 0.67f;
    private static final int TOP = 26;
    private static final int BOTTOM = 24;
    private final Screen parent;
    private final List<Option<?>> options = new ArrayList();
    private final AbstractConfig config;
    public double scrollerAmount;
    private boolean dragging;

    public CraterConfigScreen(AbstractConfig config, Screen parent, Object subConfig) {
        super((Component)Component.translatable((String)("cl." + config.getClass().getSimpleName().toLowerCase() + ".title")));
        this.parent = parent;
        this.config = config;
        if (subConfig != null) {
            this.setupScreenFromConfig(subConfig, subConfig.getClass());
        } else {
            this.setupScreenFromConfig(config, config.getClass());
        }
    }

    public CraterConfigScreen(AbstractConfig config, Screen parent) {
        this(config, parent, null);
    }

    private static Component toText(Enum<?> val) {
        return Component.translatable((String)val.toString());
    }

    private static Component toText(Boolean bool) {
        return Component.translatable((String)bool.toString());
    }

    private void setupScreenFromConfig(Object object, Class<?> clazz) {
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                int fieldModifiers = field.getModifiers();
                if (object == null || Modifier.isStatic(fieldModifiers) || Modifier.isTransient(fieldModifiers)) continue;
                try {
                    String[] tooltipLang;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    if (field.isAnnotationPresent(HideFromScreen.class)) {
                        return;
                    }
                    Object val = field.get(object);
                    String baseLangKey = "cl." + clazz.getSimpleName().toLowerCase() + "." + field.getName().toLowerCase();
                    if (field.isAnnotationPresent(SpecComment.class)) {
                        String[] stringArray = new String[1];
                        v1 = stringArray;
                        stringArray[0] = field.getAnnotation(SpecComment.class).value();
                    } else {
                        v1 = tooltipLang = new String[]{};
                    }
                    if (field.isAnnotationPresent(Tooltip.class)) {
                        tooltipLang = field.getAnnotation(Tooltip.class).value();
                    }
                    this.add((Component)Component.translatable((String)baseLangKey), val, () -> val, ret -> {
                        try {
                            field.set(object, ret);
                            this.config.saveConfig(this.config);
                        }
                        catch (IllegalAccessException e) {
                            CraterConstants.LOG.error("Failed to update value for field {} in config {}", new Object[]{field.getName(), this.config.getConfigName(), e});
                        }
                    }, field.isAnnotationPresent(SubConfig.class), tooltipLang);
                }
                catch (IllegalAccessException e) {
                    CraterConstants.LOG.error("Failed to access value for field {} in config {}", new Object[]{field.getName(), this.config.getConfigName(), e});
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    public <T> void add(Component text, T value, @Nullable Supplier<T> defaultValue, Consumer<T> savingConsumer, boolean isSubConfig, String ... langKeys) {
        Option<?> option = this.createOption(value, isSubConfig);
        option.text = text;
        option.defaultValue = defaultValue;
        option.savingConsumer = savingConsumer;
        option.originalValue = value;
        option.value = value;
        option.setLangKeys(List.of(langKeys));
        this.options.add(option);
        option.onAdd();
    }

    private <T> Option<?> createOption(T value, boolean isSubConfig) {
        if (value instanceof Enum) {
            ?[] objects = value.getClass().getEnumConstants();
            return new ToggleButton<Enum>(Arrays.asList(objects), CraterConfigScreen::toText);
        }
        if (value instanceof Boolean) {
            return new ToggleButton<Boolean>(Arrays.asList(Boolean.TRUE, Boolean.FALSE), CraterConfigScreen::toText);
        }
        if (value instanceof String) {
            return new TextConfigOption(Function.identity(), Function.identity());
        }
        if (value instanceof Integer) {
            return new TextConfigOption<Integer>(Objects::toString, Integer::valueOf);
        }
        if (value instanceof Long) {
            return new TextConfigOption<Long>(Objects::toString, Long::valueOf);
        }
        if (value instanceof Double) {
            return new TextConfigOption<Double>(Objects::toString, Double::valueOf);
        }
        if (value instanceof Float) {
            return new TextConfigOption<Float>(Objects::toString, Float::valueOf);
        }
        if (value instanceof BigInteger) {
            return new TextConfigOption<BigInteger>(Objects::toString, BigInteger::new);
        }
        if (value instanceof BigDecimal) {
            return new TextConfigOption<BigDecimal>(Objects::toString, BigDecimal::new);
        }
        if (value instanceof ResourceLocation) {
            return new TextConfigOption<ResourceLocation>(Objects::toString, ResourceLocation::parse);
        }
        if (isSubConfig) {
            return new SubConfigWidget(this.config, this, value);
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }

    protected void init() {
        super.init();
        this.children().addAll(this.options);
        int buttonWidths = Math.min(200, (this.width - 50 - 12) / 3);
        this.addRenderableWidget((GuiEventListener)new InternalConfigButton(this, this.width / 2 - buttonWidths - 3, this.height - 22, buttonWidths, 20, (Component)Component.empty(), true));
        this.addRenderableWidget((GuiEventListener)new InternalConfigButton(this, this.width / 2 + 3, this.height - 22, buttonWidths, 20, (Component)Component.empty(), false));
    }

    public void render(@NotNull GuiGraphics matrices, int mouseX, int mouseY, float delta) {
    }

    private void renderScrollBar() {
        int listHeight = this.height - 24 - 26;
        int totalHeight = this.totalHeight();
        if (totalHeight > listHeight) {
            int maxScroll = Math.max(0, totalHeight - listHeight);
            int height = listHeight * listHeight / totalHeight;
            height = Mth.clamp((int)height, (int)32, (int)listHeight);
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.scrollerAmount * (listHeight - height) / maxScroll + 26, 26), this.height - 24 - height);
            int scrollbarPositionMaxX = this.width;
            int scrollbarPositionMinX = scrollbarPositionMaxX - 6;
            int maxY = this.height - 24;
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            buffer.addVertex((float)scrollbarPositionMinX, (float)maxY, 0.0f).setColor(0, 0, 0, 255);
            buffer.addVertex((float)scrollbarPositionMaxX, (float)maxY, 0.0f).setColor(0, 0, 0, 255);
            buffer.addVertex((float)scrollbarPositionMaxX, 26.0f, 0.0f).setColor(0, 0, 0, 255);
            buffer.addVertex((float)scrollbarPositionMinX, 26.0f, 0.0f).setColor(0, 0, 0, 255);
            buffer.addVertex((float)scrollbarPositionMinX, (float)(minY + height), 0.0f).setColor(0.5f, 0.5f, 0.5f, 1.0f);
            buffer.addVertex((float)scrollbarPositionMaxX, (float)(minY + height), 0.0f).setColor(0.5f, 0.5f, 0.5f, 1.0f);
            buffer.addVertex((float)scrollbarPositionMaxX, (float)minY, 0.0f).setColor(0.5f, 0.5f, 0.5f, 1.0f);
            buffer.addVertex((float)scrollbarPositionMinX, (float)minY, 0.0f).setColor(0.5f, 0.5f, 0.5f, 1.0f);
            buffer.addVertex((float)scrollbarPositionMinX, (float)(minY + height - 1), 0.0f).setColor(0.67f, 0.67f, 0.67f, 1.0f);
            buffer.addVertex((float)(scrollbarPositionMaxX - 1), (float)(minY + height - 1), 0.0f).setColor(0.67f, 0.67f, 0.67f, 1.0f);
            buffer.addVertex((float)(scrollbarPositionMaxX - 1), (float)minY, 0.0f).setColor(0.67f, 0.67f, 0.67f, 1.0f);
            buffer.addVertex((float)scrollbarPositionMinX, (float)minY, 0.0f).setColor(0.67f, 0.67f, 0.67f, 1.0f);
        }
    }

    private void renderShadow(PoseStack matrices) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        Matrix4f matrix = matrices.last().pose();
        buffer.addVertex(matrix, 0.0f, 30.0f, 0.0f).setUv(0.0f, 1.0f).setColor(0, 0, 0, 0);
        buffer.addVertex(matrix, (float)this.width, 30.0f, 0.0f).setUv(1.0f, 1.0f).setColor(0, 0, 0, 0);
        buffer.addVertex(matrix, (float)this.width, 26.0f, 0.0f).setUv(1.0f, 0.0f).setColor(0, 0, 0, 185);
        buffer.addVertex(matrix, 0.0f, 26.0f, 0.0f).setUv(0.0f, 0.0f).setColor(0, 0, 0, 185);
        buffer.addVertex(matrix, 0.0f, (float)(this.height - 24), 0.0f).setUv(0.0f, 1.0f).setColor(0, 0, 0, 185);
        buffer.addVertex(matrix, (float)this.width, (float)(this.height - 24), 0.0f).setUv(1.0f, 1.0f).setColor(0, 0, 0, 185);
        buffer.addVertex(matrix, (float)this.width, (float)(this.height - 24 - 4), 0.0f).setUv(1.0f, 0.0f).setColor(0, 0, 0, 0);
        buffer.addVertex(matrix, 0.0f, (float)(this.height - 24 - 4), 0.0f).setUv(0.0f, 0.0f).setColor(0, 0, 0, 0);
    }

    protected void overlayBackground(PoseStack matrices, int h1, int h2, int color) {
        this.overlayBackground(matrices.last().pose(), 0, h1, this.width, h2, color, color, color, 255, 255);
    }

    protected void overlayBackground(Matrix4f matrix, int minX, int minY, int maxX, int maxY, int red, int green, int blue, int startAlpha, int endAlpha) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buffer.addVertex(matrix, (float)minX, (float)maxY, 0.0f).setUv((float)minX / 32.0f, (float)maxY / 32.0f).setColor(red, green, blue, endAlpha);
        buffer.addVertex(matrix, (float)maxX, (float)maxY, 0.0f).setUv((float)maxX / 32.0f, (float)maxY / 32.0f).setColor(red, green, blue, endAlpha);
        buffer.addVertex(matrix, (float)maxX, (float)minY, 0.0f).setUv((float)maxX / 32.0f, (float)minY / 32.0f).setColor(red, green, blue, startAlpha);
        buffer.addVertex(matrix, (float)minX, (float)minY, 0.0f).setUv((float)minX / 32.0f, (float)minY / 32.0f).setColor(red, green, blue, startAlpha);
    }

    public int scrollHeight() {
        int listHeight;
        int totalHeight = this.totalHeight();
        if (totalHeight <= (listHeight = this.height - 24 - 26)) {
            return 0;
        }
        return totalHeight - listHeight;
    }

    public int totalHeight() {
        int i = 8;
        for (Option<?> option : this.options) {
            i += option.height();
        }
        return i;
    }

    public boolean hasErrors() {
        for (Option<?> option : this.options) {
            if (!option.hasErrors) continue;
            return true;
        }
        return false;
    }

    public boolean isEdited() {
        for (Option<?> option : this.options) {
            if (!option.isEdited()) continue;
            return true;
        }
        return false;
    }

    public void save() {
        for (Option<?> option : this.options) {
            option.save();
            option.originalValue = option.value;
        }
    }

    public void onClose() {
        if (this.isEdited()) {
            this.minecraft.setScreen((Screen)new ConfirmScreen(this::acceptConfirm, (Component)Component.translatable((String)"t.clc.quit_config"), (Component)Component.translatable((String)"t.clc.quit_config_sure"), (Component)Component.translatable((String)"t.clc.quit_discard"), (Component)Component.translatable((String)"gui.cancel")));
        } else {
            this.minecraft.setScreen(this.parent);
        }
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (e >= 26.0 && e <= (double)(this.height - 24)) {
            this.scrollerAmount = Mth.clamp((double)(this.scrollerAmount - f * 16.0), (double)0.0, (double)this.scrollHeight());
            return true;
        }
        return super.mouseScrolled(d, e, f, g);
    }

    public boolean mouseClicked(MouseButtonEvent arg, boolean bl) {
        this.dragging = arg.input() == 0 && arg.x() >= (double)(this.width - 6) && arg.y() < (double)this.width;
        return super.mouseClicked(arg, bl);
    }

    public boolean mouseDragged(MouseButtonEvent arg, double d, double e) {
        if (super.mouseDragged(arg, d, e)) {
            return true;
        }
        if (arg.input() != 0 || !this.dragging) {
            return false;
        }
        if (e < 26.0) {
            this.scrollerAmount = 0.0;
        } else if (e > (double)(this.height - 24)) {
            this.scrollerAmount = this.scrollHeight();
        } else {
            double h = Math.max(1, this.scrollHeight());
            int j = this.height - 24 - 26;
            int k = Mth.clamp((int)((int)((float)(j * j) / (float)this.scrollHeight())), (int)32, (int)(j - 8));
            double d2 = Math.max(1.0, h / (double)(j - k));
        }
        return true;
    }

    private void acceptConfirm(boolean t) {
        if (!t) {
            this.minecraft.setScreen((Screen)this);
        } else {
            this.minecraft.setScreen(this.parent);
        }
    }

    private void renderConfigTooltip(GuiGraphics stack, Font font, int mouseX, int mouseY, int startX, int startY, int sizeX, int sizeY, String title, String ... description) {
        if (mouseX > startX && mouseX < startX + sizeX && mouseY > startY && mouseY < startY + sizeY) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.translatable((String)(String.valueOf(ChatFormatting.BOLD) + String.valueOf(ChatFormatting.YELLOW) + title)));
            for (String desc : description) {
                list.add(Component.translatable((String)desc));
            }
        }
    }
}

