/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.network;

import com.hypherionmc.craterlib.CraterConstants;
import com.hypherionmc.craterlib.core.networking.PacketRegistry;
import com.hypherionmc.craterlib.core.networking.data.PacketContext;
import com.hypherionmc.craterlib.core.networking.data.PacketHolder;
import com.hypherionmc.craterlib.core.networking.data.PacketSide;
import com.hypherionmc.craterlib.nojang.network.BridgedFriendlyByteBuf;
import com.hypherionmc.craterlib.nojang.world.entity.player.BridgedPlayer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;

public class CraterForgeNetworkHandler
extends PacketRegistry {
    private final Map<Class<?>, SimpleChannel> CHANNELS = new HashMap();

    public CraterForgeNetworkHandler(PacketSide side) {
        super(side);
    }

    @Override
    protected <T> void registerPacket(PacketHolder<T> holder) {
        if (this.CHANNELS.get(holder.messageType()) == null) {
            SimpleChannel channel = ChannelBuilder.named((ResourceLocation)holder.type().id()).clientAcceptedVersions((a, b) -> true).serverAcceptedVersions((a, b) -> true).networkProtocolVersion(1).simpleChannel();
            channel.messageBuilder(holder.messageType()).decoder(this.mojangDecoder(holder.decoder())).encoder(this.mojangEncoder(holder.encoder())).consumerNetworkThread(this.buildHandler(holder.handler())).add();
            this.CHANNELS.put(holder.messageType(), channel);
        } else {
            CraterConstants.LOG.error("Trying to register duplicate packet for type {}", holder.messageType());
        }
    }

    @Override
    public <T> void sendToServer(T packet) {
        this.sendToServer(packet, false);
    }

    @Override
    public <T> void sendToServer(T packet, boolean ignoreCheck) {
        Connection connection;
        SimpleChannel channel = this.CHANNELS.get(packet.getClass());
        if (channel.isRemotePresent(connection = Minecraft.getInstance().getConnection().getConnection()) || ignoreCheck) {
            channel.send(packet, PacketDistributor.SERVER.noArg());
        }
    }

    @Override
    public <T> void sendToClient(T packet, BridgedPlayer player) {
        SimpleChannel channel = this.CHANNELS.get(packet.getClass());
        ServerGamePacketListenerImpl connection = player.getConnection();
        if (connection == null) {
            return;
        }
        if (channel.isRemotePresent(connection.getConnection())) {
            channel.send(packet, PacketDistributor.PLAYER.with((Object)player.toMojangServerPlayer()));
        }
    }

    private <T> Function<FriendlyByteBuf, T> mojangDecoder(Function<BridgedFriendlyByteBuf, T> handler) {
        return byteBuf -> handler.apply(BridgedFriendlyByteBuf.of(byteBuf));
    }

    private <T> BiConsumer<T, FriendlyByteBuf> mojangEncoder(BiConsumer<T, BridgedFriendlyByteBuf> handler) {
        return (t, byteBuf) -> handler.accept(t, BridgedFriendlyByteBuf.of(byteBuf));
    }

    private <T> BiConsumer<T, CustomPayloadEvent.Context> buildHandler(Consumer<PacketContext<T>> handler) {
        return (message, ctx) -> {
            ctx.enqueueWork(() -> {
                PacketSide side = ctx.isServerSide() ? PacketSide.SERVER : PacketSide.CLIENT;
                ServerPlayer player = ctx.getSender();
                handler.accept(new PacketContext<Object>(BridgedPlayer.of((Player)player), message, side));
            });
            ctx.setPacketHandled(true);
        };
    }
}

