/*
 * Decompiled with CFR 0.152.
 */
package de.aichat;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.aichat.AIChat;
import de.aichat.AIChatConfig;
import de.aichat.AIChatConfigScreen;
import de.aichat.OpenAIAPI;
import de.aichat.OpenAIImageAPI;
import java.io.File;
import java.util.Objects;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class AIChatCommands {
    private final AIChatConfig config;
    private final OpenAIAPI openAIAPI;
    private static boolean openScreen = false;

    public AIChatCommands(AIChatConfig config, OpenAIAPI openAIAPI) {
        this.config = config;
        this.openAIAPI = openAIAPI;
    }

    public void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ask").then(ClientCommandManager.argument((String)"question", (ArgumentType)StringArgumentType.greedyString()).executes(this::askOpenAI)));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"askimage").then(ClientCommandManager.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).executes(this::askImage)));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"config").executes(context -> {
                openScreen = true;
                return 1;
            })).then(ClientCommandManager.literal((String)"OPENAI_API_KEY").then(ClientCommandManager.argument((String)"value", (ArgumentType)StringArgumentType.string()).executes(context -> this.setConfig((CommandContext<FabricClientCommandSource>)context, "OPENAI_API_KEY"))))).then(ClientCommandManager.literal((String)"ROLE_OF_THE_AI").then(ClientCommandManager.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.setConfig((CommandContext<FabricClientCommandSource>)context, "ROLE_OF_THE_AI"))))).then(ClientCommandManager.literal((String)"AI_MODEL").then(ClientCommandManager.argument((String)"value", (ArgumentType)StringArgumentType.string()).executes(context -> this.setConfig((CommandContext<FabricClientCommandSource>)context, "AI_MODEL")))));
        });
    }

    public void tick() {
        if (openScreen) {
            openScreen = false;
            class_310.method_1551().method_1507((class_437)new AIChatConfigScreen(null, this.config));
        }
    }

    private int askOpenAI(CommandContext<FabricClientCommandSource> context) {
        String question = StringArgumentType.getString(context, (String)"question");
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Generating response..."));
        new Thread(() -> {
            try {
                String response = this.openAIAPI.chatGPT(question);
                source.sendFeedback((class_2561)class_2561.method_43470((String)("Response: " + response)));
            }
            catch (Exception e) {
                source.sendFeedback((class_2561)class_2561.method_43470((String)("Failed to fetch response: " + e.getMessage())).method_27692(class_124.field_1061));
                AIChat.LOGGER.error("Error while communicating with OpenAI API", (Throwable)e);
            }
        }).start();
        return 1;
    }

    private int askImage(CommandContext<FabricClientCommandSource> context) {
        String args = StringArgumentType.getString(context, (String)"args");
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        String[] parts = this.parsePathAndQuestion(args);
        if (parts == null) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)"Usage: /askimage <path> <question>"));
            return 0;
        }
        String AIModel = this.config.getModel();
        if (Objects.equals(AIModel, "gpt-3.5-turbo")) {
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Error: " + AIModel + " is a model wich cannot analyze images please use any gpt-4 model or just press the reset button in the config screen")).method_27692(class_124.field_1061));
            source.sendFeedback((class_2561)class_2561.method_43470((String)"[Change model]").method_27692(class_124.field_1067).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/config AI_MODEL gpt-4o-mini")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)"Automatically change to model gpt-4o-mini")))));
            return 1;
        }
        String imagePath = this.normalizePath(parts[0]);
        String question = parts[1];
        source.sendFeedback((class_2561)class_2561.method_43470((String)"Analyzing image..."));
        new Thread(() -> {
            try {
                OpenAIImageAPI imageAPI = new OpenAIImageAPI(this.config);
                String response = imageAPI.analyzeImage(imagePath, question);
                source.sendFeedback((class_2561)class_2561.method_43470((String)("Response: " + response)));
            }
            catch (Exception e) {
                source.sendFeedback((class_2561)class_2561.method_43470((String)("Failed to fetch response: " + e.getMessage())).method_27692(class_124.field_1061));
                AIChat.LOGGER.error("Error while communicating with OpenAI API", (Throwable)e);
            }
        }).start();
        return 1;
    }

    private int setConfig(CommandContext<FabricClientCommandSource> context, String key) {
        String value = StringArgumentType.getString(context, (String)"value");
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        switch (key) {
            case "OPENAI_API_KEY": {
                this.config.setApiKey(value);
                break;
            }
            case "ROLE_OF_THE_AI": {
                this.config.setContent(value);
                break;
            }
            case "AI_MODEL": {
                this.config.setModel(value);
                break;
            }
            default: {
                source.sendFeedback((class_2561)class_2561.method_43470((String)("Invalid config key: " + key)));
                return 0;
            }
        }
        this.config.saveConfig();
        source.sendFeedback((class_2561)class_2561.method_43470((String)("Configuration updated: " + key + " = " + value)));
        return 1;
    }

    private String[] parsePathAndQuestion(String args) {
        if ((args = args.trim()).isEmpty()) {
            return null;
        }
        if (args.startsWith("\"")) {
            int endQuote = args.indexOf("\"", 1);
            if (endQuote == -1) {
                return null;
            }
            String path = args.substring(1, endQuote);
            String question = args.substring(endQuote + 1).trim();
            if (question.isEmpty()) {
                return null;
            }
            return new String[]{path, question};
        }
        int firstSpace = args.indexOf(" ");
        if (firstSpace == -1) {
            return null;
        }
        return new String[]{args.substring(0, firstSpace), args.substring(firstSpace + 1)};
    }

    private String normalizePath(String path) {
        return path.replace("/", File.separator).replace("\\", File.separator).replace("\"", "");
    }
}

