/*
 * Decompiled with CFR 0.152.
 */
package de.aichat;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import de.aichat.AIChat;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class AIChatConfig {
    private String apiKey;
    private String content;
    private String model;
    private static final String CONFIG_FILE_PATH = "config/aichat-config.json";

    public AIChatConfig() {
        this.loadConfig();
    }

    public void loadConfig() {
        File configFile = new File(CONFIG_FILE_PATH);
        if (!configFile.exists()) {
            AIChat.LOGGER.warn("Config file not found, creating default config.");
            this.createDefaultConfig();
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject config = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            this.apiKey = config.get("OPENAI_API_KEY").getAsString();
            this.content = config.get("ROLE_OF_THE_AI").getAsString();
            this.model = config.get("AI_MODEL").getAsString();
        }
        catch (IOException e) {
            AIChat.LOGGER.error("Failed to load config file", (Throwable)e);
        }
    }

    public void saveConfig() {
        JsonObject config = new JsonObject();
        config.add("OPENAI_API_KEY", (JsonElement)new JsonPrimitive(this.apiKey));
        config.add("ROLE_OF_THE_AI", (JsonElement)new JsonPrimitive(this.content));
        config.add("AI_MODEL", (JsonElement)new JsonPrimitive(this.model));
        File configFile = new File(CONFIG_FILE_PATH);
        configFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(configFile);){
            writer.write(config.toString());
            writer.flush();
            AIChat.LOGGER.info("Config file saved successfully.");
        }
        catch (IOException e) {
            AIChat.LOGGER.error("Failed to save config file", (Throwable)e);
        }
    }

    private void createDefaultConfig() {
        this.apiKey = "";
        this.content = "You are an assistant implemented in a Minecraft Mod to help players and you give short answers with a maximum length of 4 short Sentences";
        this.model = "gpt-4o-mini";
        this.saveConfig();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }
}

