/*
 * Decompiled with CFR 0.152.
 */
package de.aichat;

import de.aichat.AIChatConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

public class OpenAIAPI {
    private final AIChatConfig config;

    public OpenAIAPI(AIChatConfig config) {
        this.config = config;
    }

    public String chatGPT(String message) {
        String url = "https://api.openai.com/v1/chat/completions";
        try {
            String inputLine;
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Authorization", "Bearer " + this.config.getApiKey());
            con.setRequestProperty("Content-Type", "application/json");
            String body = "{\"model\": \"" + this.config.getModel() + "\", \"messages\": [{\"role\": \"user\", \"content\": \"" + this.config.getContent() + message + "\"}]}";
            con.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(con.getOutputStream());
            writer.write(body);
            writer.flush();
            writer.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return OpenAIAPI.extractContentFromResponse(response.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String extractContentFromResponse(String response) {
        int startMarker = response.indexOf("content") + 11;
        int endMarker = response.indexOf("\"", startMarker);
        String rawContent = response.substring(startMarker, endMarker);
        return rawContent.replace("\\n", " ");
    }
}

