/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.block;

import de.sarocesch.sarosroadblocksmod.block.AsphaltBlock;
import de.sarocesch.sarosroadblocksmod.block.SidewalkBlock;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrashBarrierCornerBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty OFFSET_PX = IntegerProperty.m_61631_((String)"offset_px", (int)0, (int)14);

    public CrashBarrierCornerBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60913_(3.0f, 6.0f).m_60999_().m_60955_().m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OFFSET_PX, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return true;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        ItemStack tool = player.m_21205_();
        if (tool.m_204117_(ItemTags.f_271360_) || tool.m_41720_() instanceof PickaxeItem) {
            return super.m_5880_(state, player, world, pos) * 6.0f;
        }
        return super.m_5880_(state, player, world, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape base = switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> Shapes.m_83124_((VoxelShape)CrashBarrierCornerBlock.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[]{CrashBarrierCornerBlock.m_49796_((double)5.5, (double)7.075, (double)5.5, (double)16.0, (double)12.975, (double)7.0), CrashBarrierCornerBlock.m_49796_((double)5.3, (double)7.075, (double)5.5, (double)16.0, (double)12.975, (double)16.0)});
            case Direction.EAST -> Shapes.m_83124_((VoxelShape)CrashBarrierCornerBlock.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[]{CrashBarrierCornerBlock.m_49796_((double)9.0, (double)7.075, (double)5.5, (double)10.5, (double)12.975, (double)16.0), CrashBarrierCornerBlock.m_49796_((double)0.0, (double)7.075, (double)5.3, (double)10.5, (double)12.975, (double)16.0)});
            case Direction.WEST -> Shapes.m_83124_((VoxelShape)CrashBarrierCornerBlock.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[]{CrashBarrierCornerBlock.m_49796_((double)5.5, (double)7.075, (double)0.0, (double)7.0, (double)12.975, (double)10.5), CrashBarrierCornerBlock.m_49796_((double)5.5, (double)7.075, (double)0.0, (double)16.0, (double)12.975, (double)10.7)});
            default -> Shapes.m_83124_((VoxelShape)CrashBarrierCornerBlock.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[]{CrashBarrierCornerBlock.m_49796_((double)0.0, (double)7.075, (double)9.0, (double)10.5, (double)12.975, (double)10.5), CrashBarrierCornerBlock.m_49796_((double)0.0, (double)7.075, (double)0.0, (double)10.7, (double)12.975, (double)10.5)});
        };
        int off = (Integer)state.m_61143_((Property)OFFSET_PX);
        return base.m_83216_(0.0, -((double)off / 16.0), 0.0);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, OFFSET_PX});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean water = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        int offset = this.computeOffsetPx((LevelAccessor)context.m_43725_(), context.m_8083_().m_7495_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water))).m_61124_((Property)OFFSET_PX, (Comparable)Integer.valueOf(offset));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if (facing == Direction.DOWN) {
            int newOff = this.computeOffsetPx(world, currentPos.m_7495_());
            if ((Integer)state.m_61143_((Property)OFFSET_PX) != newOff) {
                return (BlockState)state.m_61124_((Property)OFFSET_PX, (Comparable)Integer.valueOf(newOff));
            }
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.m_49635_(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this, 1));
    }

    private int computeOffsetPx(LevelAccessor level, BlockPos belowPos) {
        BlockState below = level.m_8055_(belowPos);
        int h = 16;
        if (below.m_60734_() instanceof AsphaltBlock) {
            v = (AsphaltBlock.Variant)((Object)below.m_61143_(AsphaltBlock.VARIANT));
            h = this.heightFromVariant((AsphaltBlock.Variant)v);
        } else if (below.m_60734_() instanceof SidewalkBlock) {
            v = (SidewalkBlock.Variant)((Object)below.m_61143_(SidewalkBlock.VARIANT));
            h = this.heightFromVariant((SidewalkBlock.Variant)v);
        } else if (below.m_60734_() instanceof SlabBlock) {
            SlabType slabType = (SlabType)below.m_61143_((Property)SlabBlock.f_56353_);
            h = slabType == SlabType.BOTTOM ? 8 : (slabType == SlabType.TOP ? 16 : 16);
        }
        int off = 16 - h;
        if (off < 0) {
            off = 0;
        }
        if (off > 14) {
            off = 14;
        }
        return off;
    }

    private int heightFromVariant(AsphaltBlock.Variant v) {
        return switch (v) {
            case AsphaltBlock.Variant.ONE -> 15;
            case AsphaltBlock.Variant.TWO -> 14;
            case AsphaltBlock.Variant.THREE -> 13;
            case AsphaltBlock.Variant.FOUR -> 12;
            case AsphaltBlock.Variant.FIVE -> 11;
            case AsphaltBlock.Variant.SIX -> 10;
            case AsphaltBlock.Variant.SEVEN -> 9;
            case AsphaltBlock.Variant.EIGHT -> 8;
            case AsphaltBlock.Variant.NINE -> 7;
            case AsphaltBlock.Variant.TEN -> 6;
            case AsphaltBlock.Variant.ELEVEN -> 5;
            case AsphaltBlock.Variant.TWELVE -> 4;
            case AsphaltBlock.Variant.THIRTEEN -> 3;
            case AsphaltBlock.Variant.FOURTEEN -> 2;
            case AsphaltBlock.Variant.FIFTEEN -> 1;
            default -> 16;
        };
    }

    private int heightFromVariant(SidewalkBlock.Variant v) {
        return switch (v) {
            case SidewalkBlock.Variant.ONE -> 15;
            case SidewalkBlock.Variant.TWO -> 14;
            case SidewalkBlock.Variant.THREE -> 13;
            case SidewalkBlock.Variant.FOUR -> 12;
            case SidewalkBlock.Variant.FIVE -> 11;
            case SidewalkBlock.Variant.SIX -> 10;
            case SidewalkBlock.Variant.SEVEN -> 9;
            case SidewalkBlock.Variant.EIGHT -> 8;
            case SidewalkBlock.Variant.NINE -> 7;
            case SidewalkBlock.Variant.TEN -> 6;
            case SidewalkBlock.Variant.ELEVEN -> 5;
            case SidewalkBlock.Variant.TWELVE -> 4;
            case SidewalkBlock.Variant.THIRTEEN -> 3;
            case SidewalkBlock.Variant.FOURTEEN -> 2;
            case SidewalkBlock.Variant.FIFTEEN -> 1;
            default -> 16;
        };
    }
}

