/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.item;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import de.sarocesch.sarosroadblocksmod.SarosRoadBlocksModMod;
import de.sarocesch.sarosroadblocksmod.block.AsphaltBlock;
import de.sarocesch.sarosroadblocksmod.config.ModConfigs;
import de.sarocesch.sarosroadblocksmod.util.RoadTextureManager;
import de.sarocesch.sarosroadblocksmod.world.inventory.GUIMenu;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class BrushItem
extends Item {
    public BrushItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        list.add((Component)Component.m_237115_((String)"tooltip.sarosroadblocksmod.brushitem.key"));
    }

    private boolean isPainted(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_("Painted");
    }

    private void togglePainted(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        boolean painted = !this.isPainted(stack);
        tag.m_128379_("Painted", painted);
        stack.m_41784_().m_128405_("CustomModelData", painted ? 1 : 0);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        ItemStack stack = context.m_43722_();
        if (player != null && !player.m_36204_(context.m_8083_(), context.m_43719_(), stack)) {
            if (((Boolean)ModConfigs.DEBUG_BRUSH.get()).booleanValue()) {
                SarosRoadBlocksModMod.LOGGER.warn("[Brush] no permission to use at {} {} {}", (Object)context.m_8083_().m_123341_(), (Object)context.m_8083_().m_123342_(), (Object)context.m_8083_().m_123343_());
                player.m_5661_((Component)Component.m_237115_((String)"message.saros_road_blocks_mod.brush.no_permission"), true);
            }
            return InteractionResult.FAIL;
        }
        if (player != null && player.m_6144_()) {
            if (!world.m_5776_()) {
                player.m_5893_((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new GUIMenu(windowId, playerInventory, null), (Component)Component.m_237115_((String)"gui.saros_road_blocks_mod.gui")));
            }
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (block instanceof AsphaltBlock) {
            AsphaltBlock asphaltBlock = (AsphaltBlock)block;
            CompoundTag itemNbt = stack.m_41784_();
            String modi = itemNbt.m_128461_("modi");
            BlockState newState = blockState;
            boolean textureChanged = false;
            if ("rotate".equals(modi)) {
                newState = blockState.rotate((LevelAccessor)world, pos, Rotation.CLOCKWISE_90);
            } else if ("remove".equals(modi)) {
                newState = (BlockState)blockState.m_61124_(AsphaltBlock.TEXTURE_VARIANT, (Comparable)((Object)AsphaltBlock.TextureVariant.DEFAULT));
                RoadTextureManager.setTextureForBlock(world, pos, "default");
                textureChanged = true;
                if (!world.m_5776_()) {
                    world.m_7260_(pos, blockState, newState, 3);
                }
            } else {
                try {
                    if (((Boolean)ModConfigs.DEBUG_BRUSH.get()).booleanValue()) {
                        SarosRoadBlocksModMod.LOGGER.info("[Brush] applying modi={} at {} {} {}", (Object)modi, (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
                    }
                    AsphaltBlock.TextureVariant variant = AsphaltBlock.TextureVariant.valueOf(modi.toUpperCase());
                    newState = (BlockState)blockState.m_61124_(AsphaltBlock.TEXTURE_VARIANT, (Comparable)((Object)variant));
                    Direction playerFacing = player.m_6350_();
                    newState = (BlockState)newState.m_61124_((Property)AsphaltBlock.FACING, (Comparable)playerFacing);
                    RoadTextureManager.setTextureForBlock(world, pos, modi.toLowerCase());
                    textureChanged = true;
                    if (!world.m_5776_()) {
                        world.m_7260_(pos, blockState, newState, 3);
                    }
                    if (newState != blockState || textureChanged) {
                        this.playPaintSound(world, pos);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (((Boolean)ModConfigs.DEBUG_BRUSH.get()).booleanValue() && player != null) {
                        player.m_5661_((Component)Component.m_237110_((String)"message.saros_road_blocks_mod.brush.invalid_mode", (Object[])new Object[]{modi}), true);
                        SarosRoadBlocksModMod.LOGGER.error("[Brush] invalid modi '{}'", (Object)modi);
                    }
                    return InteractionResult.PASS;
                }
            }
            if (newState != blockState || textureChanged) {
                BlockEntity blockEntity;
                world.m_7731_(pos, newState, 3);
                if (!world.m_5776_() && (blockEntity = world.m_7702_(pos)) != null) {
                    blockEntity.m_6596_();
                    world.m_7260_(pos, newState, newState, 3);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (((Boolean)ModConfigs.DEBUG_BRUSH.get()).booleanValue() && player != null) {
            player.m_5661_((Component)Component.m_237115_((String)"message.saros_road_blocks_mod.brush.not_asphalt"), true);
            SarosRoadBlocksModMod.LOGGER.warn("[Brush] tried to use on non-asphalt at {} {} {}", (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
        return InteractionResult.PASS;
    }

    private void playPaintSound(Level world, BlockPos pos) {
        File configroads = new File(FMLPaths.GAMEDIR.get().toString() + "/config/", File.separator + "saro\u00b4s_road_blocks_mod.json");
        try {
            ResourceLocation soundLocation;
            String line;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(configroads));
            StringBuilder jsonstringbuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                jsonstringbuilder.append(line);
            }
            bufferedReader.close();
            JsonObject main = (JsonObject)new Gson().fromJson(jsonstringbuilder.toString(), JsonObject.class);
            if (main.get("sounds").getAsBoolean() && ForgeRegistries.SOUND_EVENTS.containsKey(soundLocation = new ResourceLocation("saros_road_blocks_mod:streichen"))) {
                if (!world.m_5776_()) {
                    world.m_5594_(null, pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

